# Preferred reporting items for systematic reviews and meta-analyses in ecology and evolutionary biology: a PRISMA extension

Rose E. O'Dea1\* $\textcircled { 1 }$ , Malgorzata Lagisz $1 \oplus$ , Michael D. Jennions $2 \textcircled { \circ }$ , Julia Koricheva³ D Daniel W.A. Noble $1 { , } 2 \oplus$ ,Timothy H. Parker4 $\textcircled{1}$ ,Jessica Gurevitch $5 \oplus$ ,MatthewJ.Page D, Gavin Stewart7 $\textcircled{1}$ , David Moher $\textcircled{1}$ and Shinichi Nakagawa1\* ①

$^ { 1 }$ Evoution $\ddot { \odot }$ Ecology ReseachCentreandScholofologcaladEnroentaliences,UivesityofeSouthWalesSydey Australia   
$2$ Researchhotraleityieeder   
$^ 3$ DepartmentofgicalecesRoaHoayUesityodonmuey   
$^ 4$ DepartmentofBiology, Whitman Coege, Walla Walla, WA,99362, U.SA.   
$^ { 5 }$ DepartentofoUetoU   
$^ 6$ School ofPublicHealthandreentatieedcine,nash University,elboume,VIstrla   
$^ { 7 }$ ScooftU   
$^ { 8 }$ Cetreford Ottava, ON, K1H 8L6, Canada

# ABSTRACT

Since the early l99Os, ecologists and evolutionary biologists have aggregated primary research using meta-analytic methods to understand ecological and evolutionary phenomena. Meta-analyses can resolvelong-standing disputes,dispel spurious claims,and generate new research questions.At their worst, however,meta-analysis publications are wolves in sheep'sclothing: subjective with biased conclusions,hidden undercoats ofobjectiveauthority.Conclusions canberendered unreliable by inappropriate statistical methods,problems with the methods used to select primary research, or problems within the primary research itself. Because of these risks, meta-analyses are increasingly conducted as part of systematic reviews, which use structured, transparent,and reproducible methods to collate and summarise evidence. For readers to determine whether the conclusions from a systematic review or meta-analysis should be trusted -and to be able tobuildupon the review-authors need to report what theydid,whytheydid it,and what they found.Complete,transparent,and reproducible reporting is measured by ‘reporting quality'.To asss perceptions and standards of reporting quality of systematic reviews and meta-analyses published in ecology and evolutionary biology, we surveyed 208 researchers withrelevantexperience(asauthors,reviewers,oreditors),andconducteddetailedevaluationsofl02 systematic review and meta-analysis papers published between 2010 and 2019. Reporting quality was far below optimal and approximately normally distributed. Measured reporting quality was lower than what the community perceived, particularly for the systematic review methods required to measure trustworthines.The minority ofasessed papers that referenced a guideline $( \sim 1 6 \% )$ showed substantially higher reporting quality than average, and surveyed researchers showed interest in using a reporting guideline to improve reporting quality.The leading guideline for improving reporting quality of systematic reviews is the Preferred Reporting Items for Systematic reviews and Meta-Analyses (PRISMA) statement.Here we unveil an extension of PRISMA to serve the meta-analysis community in ecology and evolutionary biology: PRISMA-EcoEvo (version 1.0).PRISMA-EcoEvo is achecklist of 27 main items that, when applicable, should bereported in systematic review and meta-analysis publicationssummarising primary research in ecologyand evolutionarybiology.In this explanationand elaborationdocument, we provide guidancefor authors,reviewers,and editors,with explanations for each item on the checklist, including supplementary examples from published papers. Authors can consult this PRISMA-EcoEvo guideline both in the planning and writing stages ofa systematic review and meta-analysis, to increase reporting qualityof submited manuscripts.Reviewers and editors canuse the checklist to assssreportig quality in themanuscripts they review. Overall,PRISMA-EcoEvo is aresource for the ecology and evolutionary biology community to facilitate transparent and comprehensively reported systematic reviews and meta-analyses.

Key words:comparativeanalysis,critical appraisal, evidence synthesis,non-independence,open science,studyquality pre-registration,registration

# CONTENTS

I. Introduction .. .1696   
II.Primer a: terminology 1697   
III. Abstract & introduction 1698   
IV. Primer b: types of questions .1702   
V. Registration .1703   
VI. Primer c: registration and registered reports .1703   
VII. Finding and extracting information .1704   
VIII. Primer d: bias from primary studies .1706   
IX. Analysis methods. .1707   
X.Primer e: phylogenetic non-independence .1711   
XI. Reporting results .1711   
XII. Discussion and contributions .1714   
XIII. How and why to use prisma-ecoevo .1715   
(1）PRISMA-EcoEvo for authors .1715   
(2) PRISMA-EcoEvo for reviewers and editors .1715   
(3) Valuing permanent online repositories .1716   
(4) Comparisons with PRISMA-2020 .1716   
XIV. Conclusions .1716   
XV. Acknowledgements, author contributions and data and code availability .1717   
XVI. References. .1717   
XVII. Supporting information .1722

# 1. INTRODUCTION

Ecological and evolutionary research topics are often distilled in systematic review and meta-analysis publications (Gurevitch et al.， 2018；Koricheva & Kulinskaya, 2019). Although terminology differs both across and within disciplines,here we use the term‘meta-analysis’to refer to the statistical synthesis of effect sizes from multiple independent studies,whereas a‘systematic review’is the outcome of a series of established, transparent,and reproducible methods to find and summarise studies (definitions are discussed further in Primer A below).As with any scientific project, systematic reviews and meta-analyses are susceptible to quality issues,limitations,and biases that can undermine the credibility of their conclusions. First, the strength of primary evidence included in the review might be weakened by selectivereportingand research biases(Jennions& Moller,2O02; Forstmeier, Wagenmakers & Parker, 2017; Fraser et al., 2O18). Second, reviews might be conducted or communicated in ways that summarise existing evidence inaccurately (Whittaker, 201O; Ioannidis, 2016). Systematic review methods have been designed to identify and mitigate both these threats to credibility (Haddaway & Macura, 2018)

but, from the details that authors of meta-analyses report, it is often unclear whether systematic review methods have been used in ecology and evolution. For a review to provide a firm base of knowledge on which researchers can build, it is essential that review authors transparently report their aims, methods, and outcomes (Liberati et al., 2Oo9; Parker et al., 2016a).

In evidence-based medicine,where biased conclusions from systematic reviews can endanger human lives, transparent reporting is promoted by reporting guidelines and checklists such as the Preferred Reporting Items for Systematic reviews and Meta-Analyses (PRISMA) statement. PRISMA, first published in 2009 (Moher et al.,2009)and recently updated as PRISMA-2020 (Page et al., 2021b), describes minimum reporting standards for authors of systematic reviews of healthcare interventions.PRISMA has been widely cited and endorsed by prominent journals,and there is evidence of improved reporting quality in clinical research reviews following its publication (Page & Moher, 2Ol7). Several extensions of PRISMA have been published to suit different types of reviews (e.g.PRISMA for Protocols, PRISMA for Network Meta-Analyses,and PRISMA for individual patient data:Hutton et al.，2015；Moher et al.，2015；Stewart et al., 2015).

Ecologists and evolutionary biologists seldom reference reporting guidelines in systematic reviews and meta-analyses. However, there is community support for wider use of reporting guidelines (based on our survey of 2O8 researchers; see online Supporting Information) and benefits to their adoption. In a representative sample of lO2 systematic review and meta-analysis papers published between 2010 and 2019, the $1 6 \%$ of papers that mentioned a reporting guideline showed above-average reporting quality (Fig. 1). In all but one paper, the reporting guideline used by authors was PRISMA, despite it being focussed on reviews of clinical research. While morediscipline-appropriate reporting checklists are available for our fields (e.g.ROSES RepOrting standards for Systematic Evidence Syntheses'； Haddaway et al.，2O18；and the Tools for Transparency in Ecology and Evolution'; Parker et al., 2O16a),these have so far focussed on applied topics in environmental evidence, and/or lack explanations and examples for meta-analysis reporting items.Ecologists and evolutionary biologists need a detailed reporting guideline for systematic review and meta-analysis papers.

![](images/3a89ddb4c4de580a910977dd1f638ea7545fbf066e6fb4b7541e8383e0bbb8e0.jpg)  
Fig 1.Results from our assessment of reporting quality of systematic reviews and meta-analyses published between 2010 and 2019,in ecology and evolutionary biology $\mathit { n } = 1 0 2$ ).For each paper, the reporting score represents the mean ‘average item $\%$ score’across all applicable items.Full detailsare provided in the Supporting Information and supplementary code.Red columns indicate the minority of papers that cited a reporting guideline $( n = 1 5$ cited PRISMA,and $n = 1$ cited Koricheva $\&$ Gurevitch,20l4).The subset of papers that referenced a reporting guideline tended to have higher reporting scores (note that these observational data cannot distinguish between checklists causing better reporting，or authors with better reporting practices being more likely to reportusing checklists). Welch's $t$ -test: $t$ -value $\begin{array} { r l } { = } & { { } ~ 5 . 2 1 } \end{array}$ ， $\bar { \mathrm { d f } } \bar { = } 2 5 . 6 5$ ·， $\bar { P } < 0 . 0 0 1$ ：

We have designed version 1.O of a PRISMA extension for ecology and evolutionary biology: PRISMA-EcoEvo. This guideline caters for the types of reviews and methods common within our fields.For example, meta-analyses in ecology and evolutionary biology often combine large numbers of diverse studies to summarise patterns across multiple taxa and/orenvironmentalconditions(Nakagawa& Santos, 2012; Senior et al., 2016). Aggregating diverse studies often creates multiple types of statistical non-independence that require careful consideration (Noble et al., 2Ol7),and guidance on reporting these statistical issues is not comprehensively covered by PRISMA.Conversely， some of the items on PRISMA are yet to be normalised within ecology and evolution (e.g. risk of bias assessment,and duplicate data extraction).Without pragmatic consideration of these differences between fields,most ecologists and evolutionary biologists are unlikely to use a reporting guideline for systematic reviews and meta-analyses.

Here we explain every item of the PRISMA-EcoEvo checklist,for use by authors,peer-reviewers,and editors (Fig. 2). We also include extended discusson of the more difficult topics for authors in five‘Primer' sections (labelled AE).Table l presents a checklist of sub-items, to aid the assessment of partial reporting. The full checklist applies to systematic reviews with a meta-analysis,but many of the items will be applicable to systematic reviews without a meta-analysis, and meta-analyses without a systematic review. Examples of each item from a published paper are presented in the Supporting Information, alongside text descriptions of current reporting practices.

# 1I. PRIMER A: TERMINOLOGY

Within the ecology and evolutionary biology community there are terminological differences regarding how‘metaanalysis’ is defined (Vetter,Rucker & Storch,2O13). In the broadest sense,any aggregation of results from multiple studies is sometimes referred to as a ‘meta-analysis’ (including the common but inadvisable practice of tallying the number of significant versus non-significant results, i.e.‘vote-counting'; Vetter et al., 2013; Koricheva & Gurevitch,2014; Gurevitch et al.,2O18).Here,we reserve the term‘meta-analysis'for studies in which effect sizes from multiple independent studies are combined in a statistical model, to give an estimate of a pooled effect size and error. Each effect size represents a result,and the effect sizes from multiple studies are expressed on the same scale.Usually the effect sizes are weighted so that more precise estimates (lower sampling error) have a greater impact on the pooled effect size than imprecise estimates (although unweighted analyses can sometimes be justified; see Item 12).

In comparison with meta-analyses,which have been used in ecology and evolutionary biology for nearly 3O years (the firstmeta-analysisinecologywaspublishedby Jarvinen, 199l), systematic reviews are only now becoming

PRISMA-EcoEvo guidance for:

authors reviewers editors √   
planning reviewing 回 reporting   
registration reviewing reporting 回 author   
reporting guidelines

# Preferred Reporting Items for Systematic reviews & Meta-Analyses in Ecology and Evolutionary biology

![](images/205aa28daca33fb8a54e3ca6c2e5614d5a991aab06b9c4ba124dd328edc29ba7.jpg)  
Fig 2.PRISMA-EcoEvo for authors，peer-reviewers，and editors.Planning and protocols are shown in grey because, while PRISMA-EcoEvo can point authors in the right direction,authors should seek additional resources for detailed conduct guidance.Authors can use PRISMA-EcoEvo asa reporting guideline for both registered reports (Primer C) and completed manuscripts.Reviewers and editors canuse PRISMA-EcoEvo to assess reporting quality of the systematic review and meta-analysis manuscripts they read.Editors can promote high reporting quality by asking submitting authors tocomplete thePRISMA-EcoEvo checklist，eitherby downloading a static file at https://osf.io/t8qd2/,or by using an interactive web application at https://prisma-ecoevo.shi nyapps.io/checklist/.

an established method (Gurevitch et al., 2O18; Berger-Tal et al.,2019; but see Pullin & Stewart, 2006). Systematicreview methods are concerned with how information was gathered and synthesised.In fields such as medicine and conservation biology,the required steps for a systematic review are as follows: defining specific review questions; identifying all likely relevant records; screening studies against predefined eligibility criteria；assessing the risk of bias both within and across studies (i.e.‘critical appraisal’; Primer D); extracting data; and synthesising results (which might include a meta-analysis) (Pullin & Stewart, 2Oo6; Liberati et al., 2009; Haddaway & Verhoeven，2O15；James,Randall& Haddaway, 2016; Cooke et al., 2017; Higgins et al., 2019). Under this formal definition, systematic reviews in ecology and evolutionary biology are exceedingly rare for two reasons.First, we tend not to conduct exhaustive searches to find all relevant records (e.g. we usually rely on a sample of published sources from just one or two databases). Second, assessing the risk of bias in primary studies is very uncommon (based on the meta-analyses we assessed; see Supporting Information and Section VII).Given current best practice and usage of the term ‘systematic review' in ecology and evolutionary biology, the PRISMA-EcoEvo checklist is targeted towards meta-analyses that were conducted on data collected from multiple sources and whose methods were structured, transparent,and reproducible.

# III. ABSTRACT& INTRODUCTION

# Item 1: Title and abstract

In the title or abstract, identify the review as a systematic review, meta-analysis,or both. In the abstract provide a summary including the aims and scope of the review, description of the data set, results of the primary outcome, conclusions, and limitations.

# Explanation and elaboration

Identifying the report as a systematic review and/or metaanalysis in the title,abstract, or keywords makes these types of reviews identifiable through database searches.It is essential that the summary of the review in the abstract is accurate because this is the only part of the review that some people will read (either by choice or because of restricted access) (Beller et al., 2Ol3).While it is currently rare for abstracts to report limitations, this practice should change. Casual readers can be misled if the abstract does not disclose limitations of the review or fails to report the result of the primary outcome.Even very concise abstracts (e.g. for journals that allow a maximum of 15O words) should state obvious limitations.To signify greater accountability,authors can report when their review was registered in advance (Item 3).

# Item 2: Aims and questions

Explain the rationale of the study, including reference to any previous reviews or meta-analyses on the topic. State the aims and scope of the study (including its generality) and its primary questions (e.g. which moderators were tested), including whether effect sizes are derived from experimental and/or observational comparisons.

# Explanation and elaboration

An effective introduction sets up the reader so that they understand why a study was done and what it entailed, making it easier to process subsequent information (Liberati et al.,20o9).In this respect, the introduction of a systematic reviewisno different tothat of primarystudies (Heard, 2Ol6).Previous review articles are likely to influence thinking around a research topic, so these reviews should be placed in context, as their absence signifies a research gap.If the introduction is well written and the study is well designed, then the reader can roughly infer what methods were used before reading the methods section.To achieve such harmony,authors should clearly lay out the scope and primary aims of the study (e.g. which taxa and types of studies; hypothesis testing or generating/exploratory). The scope is crucial because this influences many aspects of the study design (e.g.eligibility criteria; Item 4) and interpretation of results.It is also important to distinguish between experimental and observational studies, as experiments provide an easier path to causal conclusions.

<html><body><table><tr><td>Checklist item</td><td>subite</td><td>Sub-item</td><td> papersmneig</td><td>applicable No. papers</td></tr><tr><td rowspan="6">Title and abstract</td><td>11</td><td> Identify the review as a systematic review,meta-analysis,or both*</td><td>100</td><td>102</td></tr><tr><td>1.2</td><td>Summarise the aims and scope of the review</td><td>97</td><td>102</td></tr><tr><td>1.3</td><td>Describe the data set</td><td>74</td><td>102</td></tr><tr><td>1.4</td><td>State the results of the primary outcome</td><td>96</td><td>102</td></tr><tr><td>1.5</td><td>State conclusions*</td><td>94</td><td>102</td></tr><tr><td>1.6</td><td>State limitations*</td><td>17</td><td>96</td></tr><tr><td rowspan="5"> Aims and questions</td><td>2.1</td><td>Provide a rationale for the review*</td><td>100</td><td>102</td></tr><tr><td>2.2</td><td>Reference anypreviousreviews or meta-analyses ontetopic</td><td>93</td><td>75</td></tr><tr><td>2.3</td><td>State the aims and scope of the review (including its generality)</td><td>91</td><td>102</td></tr><tr><td>2.4</td><td>State the primary questions the review addresses (e.g. which moderators were tested)</td><td></td><td>102</td></tr><tr><td>2.5</td><td>Describe whether effect sizes were derived from experimental and/or observational comparisons</td><td>96 57</td><td>76</td></tr><tr><td rowspan="4"> Review registration</td><td>3.1</td><td>Register review aims,hypotheses (if applicable),and methods in a time-stamped and publicly</td><td></td><td>102</td></tr><tr><td></td><td>accessible archive and provide a link to the registration in the methods section of the manuscript. Ideally registration occurs before the search,but it can be done at any stage before data analysis</td><td></td><td></td></tr><tr><td>3.2</td><td>Describe deviations from the registered aims and methods</td><td></td><td>3</td></tr><tr><td>3.3</td><td>Justify deviations from the registered aims and methods</td><td></td><td>3</td></tr><tr><td rowspan="2">Eligibility criteria</td><td>4.1</td><td>Report the specific Criteria used for including or excluding studies when screening titles and/or abstracts, and fulltexts,according to the aims of the systematic review (e.g. study design, taxa, data</td><td>84</td><td>102</td></tr><tr><td></td><td>availability)</td><td></td><td></td></tr><tr><td rowspan="5">Finding studies</td><td>4.2 5.1</td><td>Justify criteria, if necessary (i.e. not obvious from aims and scope) Define the type of search (e.g. comprehensive search, representative sample)</td><td>54 25</td><td>67 102</td></tr><tr><td>5.2</td><td>State what sources of information were sought (e.g. published and unpublished studies, personal</td><td>89</td><td>102</td></tr><tr><td>5.3</td><td>communications)* Include,for each database searched, the exact search strings used, with keyword combinations and</td><td>49</td><td>102</td></tr><tr><td>5.4</td><td>Boolean operators Provide enough information to repeat the equivalent search (if possble), including the timespan</td><td></td><td></td></tr><tr><td></td><td>covered (start and end dates)</td><td>14</td><td>102</td></tr><tr><td rowspan="2"> Study selection</td><td>6.1</td><td>Describe how studies were selected for inclusion at each stage of the screening proces (e.g. use of</td><td>13</td><td>102</td></tr><tr><td>6.2</td><td>decision trees, screening software) Report the number of people involved and how they contributed (e.g. independent parallel screening)</td><td></td><td>102</td></tr></table></body></html>

(senuquo)   
  

<html><body><table><tr><td>Checklist item</td><td>subitcm</td><td> Sub-item</td><td></td><td> Nopaer</td></tr><tr><td>Data collection process</td><td>7.1</td><td>Describe where in the reports data were collected from (e.g.text or figures)</td><td>44</td><td>102</td></tr><tr><td></td><td>7.2</td><td>Describe how data were collected (e.g. software used to digitize figures, external data sources)</td><td>42 56</td><td>102</td></tr><tr><td></td><td>73</td><td>Describe moderator variables that were constructed from collected data (e.g. number of generations calculated from years and average generation time)</td><td></td><td>41</td></tr><tr><td></td><td>7.4</td><td>Report how mising or ambiguous information was dealt with during data collection (e.g. authors of original studies were contacted for missing descriptive statistics,and/or effect sizes were calculated</td><td>47</td><td>102</td></tr><tr><td></td><td></td><td>from test statistics)</td><td></td><td></td></tr><tr><td></td><td>7.5 7.6</td><td>Report who collected data State the number of extractions that were checked for accuracy by co-authors</td><td>10 1</td><td>102 102</td></tr><tr><td>Data items</td><td>8.1</td><td>Describe the key data sought from each study</td><td>96</td><td>102</td></tr><tr><td></td><td>8.2</td><td>Describe items that do not appear in the main results, or which could not be extracted due to insufficient information</td><td>42</td><td>53</td></tr><tr><td></td><td>8.3</td><td>Describe main assumptions or simplifications that were made (e.g. categorising both‘length&#x27; and</td><td>62</td><td>86</td></tr><tr><td></td><td></td><td>‘mass’ as‘morphology&#x27;)</td><td></td><td></td></tr><tr><td> Assessment of individual</td><td>8.4 9.1</td><td>Describe thetype ofreplicationunit (.g.individuals,broods,studysites) Describe whether the quality of studies included in the systematic review or meta-analysis was assessed</td><td>73 7</td><td>102 102</td></tr><tr><td>study quality</td><td></td><td> (e.g.blinded data collction,reportingquality,experimental versus observational)</td><td></td><td></td></tr><tr><td></td><td>9.2</td><td>Describe how information about study quality was incorporated into analyses (e.g. meta-regression and/or sensitivity analysis)</td><td>6</td><td>102</td></tr><tr><td> Effect size measures</td><td>10.1 10.2</td><td>Describe efet size(s)used Provide a reference to the equation ofeach calculated effect size (e.g.standardised mean difference,</td><td>97 63</td><td>102 91</td></tr><tr><td></td><td></td><td>log response ratio) and (if appicable)its sampling variance</td><td></td><td></td></tr><tr><td></td><td>10.3</td><td>If noreference exists，derive theequations foreach efectsizeand state the assumed sampling distribution(s)</td><td>7</td><td>28</td></tr><tr><td>Missing data</td><td>11.1</td><td>Describe any steps taken to deal with missing data during analysis (e.g.imputation, complete case, subset analysis)</td><td>37</td><td>57</td></tr><tr><td></td><td>11.2</td><td> Justify the decisions made to deal with missing data</td><td></td><td>57</td></tr><tr><td>Meta-analytic model description</td><td>12.1 12.2</td><td>Describethemodelsusedforsythesisofefect sizes Themost commonapproachinecologyandevolutionwillbearandom-effcts model,often witha</td><td>50</td><td>102 40°</td></tr><tr><td></td><td></td><td>hierarchical/multilevel structure. If other types of models are chosen (e.g. common/fixed effects</td><td></td><td></td></tr><tr><td>Software</td><td>13.1</td><td> model, unweighted model), provide justification for this choice</td><td></td><td>102</td></tr><tr><td></td><td>13.2</td><td>Describe the statistical platform used for inference (e.g. R) Describe the packages used to run models</td><td>92 74</td><td>80</td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>13</td><td></td><td>2</td><td></td></tr><tr><td></td><td></td><td>Deb</td><td>33</td><td>6 102</td></tr><tr><td> Non-independence</td><td>13.5 14.1</td><td>Describe the version numbers ofallsoftware used</td><td></td><td>102</td></tr><tr><td></td><td></td><td>Describe the types ofnon-independence encountered (e.g. phylogenetic,spatial, multiple</td><td>32</td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td>74</td><td>102</td></tr><tr><td></td><td></td><td></td><td>47</td><td>102</td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td> Deseibe hownonirtipedce has beehandld</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>14.2</td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>14.3</td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td> Justify decisions made</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td></tr><tr></table></body></html>

<html><body><table><tr><td>Checklist item</td><td> Sub-iterm</td><td>Sub-item</td><td> Papers metig</td><td> oplcaber</td></tr><tr><td rowspan="3">Meta-regression and model selection</td><td>15.1</td><td>Provide a rationale for the inclusion of moderators (covariates) that were evaluated in meta-regression models</td><td>81</td><td>94</td></tr><tr><td>15.2</td><td>Justify the number of parameters estimated in models,in relation to the number of efect sizes and studies (e.g. interaction terms were not included due to insufficient sample sizes)</td><td>20</td><td>94</td></tr><tr><td>15.3</td><td>Describe any process of model selection</td><td>80</td><td>40</td></tr><tr><td rowspan="3">Publication bias and sensitivity analyses</td><td>16.1</td><td>Describe assessments ofthe risk of bias due to missing results (e.g. publication, time-lag, and taxonomic biases)</td><td>65</td><td>102</td></tr><tr><td>16.2</td><td>Describe any steps taken to investigate the effects of such biases (if present)</td><td>47</td><td>30</td></tr><tr><td>16.3</td><td>Describe any other analyses of robustness of the results, e.g. due to effect size choice, weighting or analytical model assumptions, inclusion or exclusion of subsets of the data, or the inclusion of</td><td>35</td><td>102</td></tr><tr><td>Clarification of post hoc analyses</td><td>17.1</td><td>alternative moderator variables in meta-regressions When hypotheses were formulated after data analysis, this should be acknowledged</td><td>14</td><td>28</td></tr><tr><td rowspan="4"> Metadata, data, and code</td><td>18.1</td><td> Share metadata (i.e. data descriptions)</td><td>44</td><td>102</td></tr><tr><td>18.2</td><td> Share data required to reproduce the results presented in the manuscript</td><td>77</td><td>102</td></tr><tr><td>18.3</td><td>Share aditional data, including information that was not presented in the manuscript (e.g. raw data used to calculate effect sizes, descriptions of where data were located in papers)</td><td>39</td><td>102</td></tr><tr><td>18.4</td><td> Share analysis scripts (or, if a software package with graphical user interface (GUI) was used, then</td><td>11</td><td>102</td></tr><tr><td rowspan="4">Results of study selection process</td><td>19.1</td><td>describe full model specification and fully specify choices) Report the number of studies screened*</td><td>37</td><td>102</td></tr><tr><td>19.2</td><td>Report the number of studies excluded at each stage of screening</td><td>22</td><td>102</td></tr><tr><td>19.3 19.4</td><td>Report brief reasons for exclusion from the full-text stage</td><td>27</td><td>102</td></tr><tr><td></td><td>Present a Preferred Reporting Items for Systematic Reviews and Meta-Analyses (PRISMA)-like</td><td>19</td><td>102</td></tr><tr><td rowspan="5">Sample sizes and study characteristics</td><td>20.1</td><td>flowchart (www.prisma-statement.org)* Report the number of studies and effect sizes for data included in meta-analyses</td><td>96</td><td>91</td></tr><tr><td>20.2</td><td> Report the number of studies and efect sizes for subsets of data included in meta-regressions</td><td>57</td><td>93</td></tr><tr><td>20.3</td><td>Providea summary of keycharacteristics for reported outcomes (either in textor figures; e.g. one quarter of effect sizes reported for vertebrates and the rest invertebrates)</td><td>62</td><td>102</td></tr><tr><td>20.4</td><td>Providea summary of limitations of included moderators (e.g. colinearity and overlap between</td><td>22</td><td>87</td></tr><tr><td></td><td> moderators)</td><td></td><td></td></tr><tr><td rowspan="2">Meta-analysis</td><td>20.5 21.1</td><td>Provide a summary of characteristics related to individual study quality (risk of bias) Provideaquantitative synthesis ofresultsacrostudies,including estimates forthe mean effect size,</td><td>60 94</td><td>5</td></tr><tr><td></td><td>with confidence/credible intervals</td><td></td><td>87</td></tr><tr><td>Heterogeneity</td><td>22.1 23.1</td><td>Report indicators ofheterogeneity in the estimated effect (e.g. I,tau² and other variance components) Provide estimates ofmeta-regression slopes (i.e.regressioncoeffients)and confidence/credible</td><td>52</td><td>84</td></tr><tr><td rowspan="4">Meta-regression</td><td></td><td>intervals</td><td>78</td><td>94</td></tr><tr><td>23.2</td><td>Include estimates and confidence/credible intervals for all moderator variables that were assessed(i.e.59 complete reporting)</td><td></td><td>94</td></tr><tr><td>23.3</td><td>Report interactions, if they were included</td><td>59</td><td>27</td></tr><tr><td>23.4</td><td>Describe outcomes from model selection, if done (e.g. R² and AIC)</td><td>81</td><td>36</td></tr><tr><td> and sensitivity analyses</td><td>24.1</td><td> Provide results for the assessments of the risks of bias (e.g. Egger&#x27;s regression, funnel plots</td><td>60</td><td>102</td></tr><tr><td>Outcomes of publication bias</td><td>24.2</td><td>Provide results for the robustness of the review’s results (e.g.subgroup analyses, meta-regression of study quality, results from alternative methods of analysis,and temporal trends)</td><td>44</td><td>102</td></tr></table></body></html>

<html><body><table><tr><td>Checklist item</td><td>Ssubiter</td><td>Sub-item</td><td></td><td> No.ieaber</td></tr><tr><td>Discussion</td><td>25.1</td><td> Summarise the main findings in terms of the magnitude of effect</td><td>73</td><td>102</td></tr><tr><td></td><td>25.2</td><td>Summarise the main findings in terms of the precision of effects (e.g. size of confidence intervals,</td><td>57</td><td>102</td></tr><tr><td></td><td>25.3</td><td>statistical significance) Summarise the main findings in terms of their heterogeneity</td><td>47</td><td>89</td></tr><tr><td></td><td>25.4</td><td>Summarise the main findings in terms of their biological/practical relevance</td><td>98</td><td>102</td></tr><tr><td></td><td>25.5</td><td>Compare results with previous reviews on the topic,if available</td><td>88</td><td>72</td></tr><tr><td></td><td>25.6</td><td> Consider limitations and their influence on the generality of conclusions,such as gaps in the available</td><td>72</td><td></td></tr><tr><td></td><td></td><td>evidence (e.g. taxonomic and geographical research biases)</td><td></td><td>100</td></tr><tr><td>Contributions and funding</td><td>26.1</td><td>Provide names,afiliations, and funding sources of all co-authors</td><td>92</td><td>102</td></tr><tr><td></td><td>26.2</td><td> List the contributions of each co-author</td><td>31</td><td>102</td></tr><tr><td></td><td>26.3</td><td>Provide contact detals for the corresponding author</td><td>100</td><td></td></tr><tr><td></td><td>26.4</td><td></td><td>0</td><td>102</td></tr><tr><td></td><td>27.1</td><td>Disclose any conflicts of interest</td><td>92</td><td>8</td></tr><tr><td>References</td><td>27.2</td><td>Provide a reference list of all studies included in the systematic review or meta-analysis List included studies as referenced sources (e.g. rather than listing them in a table or supplement)</td><td>18</td><td>102 102</td></tr></table></body></html>

# IV. PRIMER B: TYPES OF QUESTIONS

Broadly, systematic reviews with meta-analyses can answer questions of two kinds: the generality of a phenomenon, or its overall effect (Gurevitch et al., 2018).When PRISMA was published in 2Oo9 for reviews assessing the overall effect (i.e.the meta-analytic intercept/mean) it recommended that questions be stated with reference to‘PICO’or‘PECO': population (e.g. adult humans at risk of cardiovascular disease), intervention or exposure (e.g. statin medication), comparator (e.g. control group taking a placebo),and outcome (e.g. difference in the number of cardiovascular disease events between the intervention and control groups) (Liberati et al., 2Oo9).When a population is limited to one species,or one subset of a population, the number of studies available to quantify the overall effect of an intervention or exposure is typically small (e.g. ${ < } 2 0$ studies） (Gurevitch et al.,20l8). However, even when ecological and evolutionary questions can be framed in terms of ‘PICO' or‘PECO', the‘population’ is often broad (e.g. vertebrates,whole ecosystems) leading to larger and more diverse data sets (Gerstner et al.,2Ol7). Examples include the effect of the latitudinal gradient on global speciesrichness(Kinlock et al., 2018; $n = 1 9 9$ studies),the effect of parasite infection on body condition in wild species (Sánchez et al.,2018; $n = 1 8 7$ studies), the effect of livestock grazing on ecosystem properties of salt marshes (Davidson et al., 2017; $n = 8 9$ studies),and the effect ofcytoplasmic genetic variation on phenotypic variation in eukaryotes (Dobler et al., 2014; $n = 6 6$ studies).

In ecological and evolutionary meta-analyses, determining the average overall effect across studies is usually of less interest than exploring the extent,and sources, of variability in effect sizes among studies. Combining a large number of studies across species or contexts increases variability and makes estimation and interpretation of the average effect difficult and arguably meaningless. Instead, exploring variables which influence the magnitude or direction of an effect can be particularly fruitful; these variables could be biological or methodological (Gerstner et al., 2O17). To explore sources of variation in effects,and quantify statistical power, it is important to report the magnitude of heterogeneity among effect sizes (i.e.differences in effect sizes between studies beyond what is expected from sampling error; Item 22). Heterogeneity is typically high when diverse studies are combined in a single meta-analysis.High heterogeneity is considered problematic in medical meta-analyses (Liberati et al., 2009; Muka et al.,202O),but it is the norm in ecology andevolutionarybiology(Stewart,2OlO；Senior et al.,2Ol6),and identifying sources of heterogeneity could produce both biological and methodological insights (Rosenberg, 2Ol3).Authors of meta-analyses in ecology and evolutionary biology should be aware that high heterogeneity reduces statistical power for a given sample size, especially for estimates of moderator effects and their interactions (Valentine, Pigott & Rothstein,2O1O). It is therefore important to report estimates of heterogeneity (Item 22) alongside full descriptions of sample sizes (Item 2O),and communicate appropriate uncertainty in analysis results.

# V.REGISTRATION

# Item 3: Review registration

Register study aims, hypotheses (if applicable), and methods in a time-stamped and publicly accessible archive. Ideally registration occurs before the search, but it can be done at any stage before data analysis. A link to the archived registration should be provided in the methods section of the manuscript. Describe and justify deviations from the registered aims and methods.

# Explanation and elaboration

Registering planned research and analyses, in a timestamped and publicly accessible archive,is easily achieved with existing infrastructure (Nosek et al., 2O18) and is a promising protection against false-positive findings (Allen & Mehler, 2O19) (discussed in Primer C).While ecologists and evolutionary biologists have been slower to adopt registrations compared to researchers in the social and medical sciences，our survey found that authors who had tried registrations viewed their experience favourably (see Supporting Information).Given that authors of systematic reviews and meta-analyses often plan their methods in advance (e.g. to increase the reliability of study screening and data extractions), only a small behavioural change would be required to register these plans in a time-stamped and publicly available archive.Inexperienced authors might feel ill-equipped to describe analysis plans in detail,but there arestillbenefitstoregisteringconceptualplans (e.g. detailed aims,hypotheses,predictions,and variables that will be extracted for exploratory purposes only). Deviations from registered plans should be acknowledged and justified in the final report (e.g. when the data collected cannot be analysed using the proposed statistical model due to violation of assumptions). Authors who are comfortable with registration might consider publishing their planned systematic review or meta-analysis as a‘registered report’，whereby the abstract, introduction and methods are submitted to a journal prior to the review being conducted. Some journals even publish review protocols before the review is undertaken (as is commonly done in environmental sciences, e.g. Greggor, Price & Shier, 2019).

# VI. PRIMER C: REGISTRATION AND REGISTEREDREPORTS

Suboptimal reporting standards are often attributed to perverse incentives for career advancement (Ioannidis, 2Oo5; Smaldino & McElreath,2016; Moher et al., 2020; Munafo et al.,2020).‘Publish or perish' research cultures reward the frequent production ofpapers,especially papers that gain citations quickly. Researchers are therefore encouraged, both directly and indirectly，to extract more-compelling narrativesfrom lesscompellingdata.For example,given multiple choices in statistical analyses,researchers might favour paths leading to statistical significance(i.e.‘P-hacking'；Simmons,Nelson& Simonsohn,201; Head et al.,2015). Similarly,there are many ways to frame results in a manuscript. Results might be more impactful when framed as evidence for a hypothesis, even if data were not collected with the intention of testing that hypothesis (a problematic practice known as ‘HARKing'—Hypothesising After the Results are Known'; Kerr, 1998). Engaging in these behaviours does not require malicious intent or obvious dishonesty.Concerted effort is required to avoid the trap of selfdeception (Forstmeier et al.， 2017； Aczel et al.， 2020).For researchers conducting a systematic review or meta-analysis, we need both to be aware that these practices could reduce the credibility of primary studies (Primer D),and guard against committing these practices when conducting and writing the review.

‘Registration’or‘pre-registration’ isan intervention intended to make it harder for researchers to oversell their results (Rice & Moher, 2O19).Registration involves publicly archiving a written record of study aims,hypotheses, experimental or observational methods,and an analysis plan prior to conducting a study (Allen & Mehler, 2019).The widespread use of public archiving of study registrations only emerged in the 20oOs when — in recognition of the harms caused by false-positive findings — the International Committee of Medical Journal Editors, World Medical Association,and the World Health Organisation,mandated that all medical trials should be registered(Goldacre, 2Ol3). Since then,psychologists and other social scientists have adopted registrations too (which they term ‘pre-registrations’;Rice & Moher, 2019), in response to high-profile cases of irreproducible research (Nelson, Simmons & Simonsohn, 2O18; Nosek et al.,2Ol9).In addition to discouraging researchers from fishing for the most compelling stories in their data, registration may also help locate unpublished null results,which are typically published more slowly than‘positive’findings (Jennions & Moller, 20o2) (i.e.registrations provide a window into researchers’‘file drawers',a goal of meta-analysts that seemed out of reach for decades; Rosenthal, 1979).

Beyond registration,a more powerful intervention is the ‘registered report',because these not only make it harder for researchers to oversell their research and selectively report outcomes,but also prevent journals basing their publication decisions on study outcomes.In a registered report, the abstract, introduction,and method sections of a manuscript are submitted for peer review prior to conducting a study, and studies are provisionally accepted for publication before their results are known (Parker, Fraser & Nakagawa, 2019). This publication style can therefore mitigate publication bias and helps to address flaws in researchers’ questions and methods before it is too late to change them. Although the ‘in principle’ acceptance for publication does rely on authors closely following their registered plans, this fidelity comes with the considerable advantage of not requiring‘surprising" results for a smooth path to publication (and, iflarge changes reverse the initial decision of provisional acceptance,authors can still submit their manuscript as a new submission). Currently, a small number of journals that publish meta-analyses in ecology and evolutionary biology accept registered reports (see https://cos.io/rr/for an updated list)and,as with a regular manuscript, the PRISMA-EcoEvo checklist can be used to improve reporting quality in registered reports.

Systematic reviews and meta-analyses are well suited for registration and registered reports because these large and complicated projects have established and predictable methodology (Moher et al., 2015; López-Lopez et al., 2018; Muka et al., 2020). Despite these advantages, in ecology and evolutionary biology registration is rare (see Supporting Information). When we surveyed authors, reviewers,and editors,we found researchers had either not considered registration as an option for systematic reviews and meta-analyses or did not consider it worthwhile. Even in medical reviews,registration rates are lower than expected (Pussegoda et al., 2O17). Rather thanaleap toperfectscience, registration is a step towards greater transparency in the research process. Still, the practice has been criticised for not addressing underlying issues with research quality and external validity (Szollosi et al., 2O2O). Illogical research questions and methods are not rescued by registration(Gelman,20l8),but registered reports provide the opportunity for them to be addressed before a study is conducted. Overall, wider adoption ofregistrations and registered reports is the clearest path towards transparent and reliable research.

should be sufficiently broad to address the research question meaningfully,while being achievable within the authors' constrained resources(time and/or funding) (Forero et al., 2019).

The eligibility criteria represent a key ‘forking path’ in any meta-analysis; slight modifications to the eligibility criteria could send the review down a path towards substantially different results (Palpacuer et al.，2O19). When planning a review,it is crucial to define explicit criteria for which studies will be included that are as objective as possible.These criteria need to be disclosed in the paper or supplementary information for the review to be replicable.It is especially important to describe criteria that do not logically follow from the aims and scope of the review (e.g.exclusion criteria chosen for convenience,such as excluding studies with missing data rather than contacting authors).

# Item 5: Finding studies

Define the type of search (e.g. comprehensive search, representative sample)，and state what sources of information were sought (e.g. published and unpublished studies, personal communications). For each database searched include the exact search strings used, with keyword combinations and Boolean operators. Provide enough information to repeat the equivalent search (if possible), including the timespan covered (start and end dates).

# Explanation and elaboration

# VII.FINDING AND EXTRACTING INFORMATION

# Item 4: Eligibility criteria

Report the specific criteria used for including or excluding studies when screening titles and/or abstracts, and full texts, according to the aims of the meta-analysis (e.g. study design, taxa, data availability). Justify criteria, if necessary (i.e. not obvious from aims and scope).

# Explanation and elaboration

Fully disclosing which studies were included in the review allows readers to assess the generality,or specificity, of the review's conclusions (Vetter et al.， 2O13).To decide upon the scope of the review, we typically use an iterative process of trial-and-error to refine the eligibility criteria, in conjunction with refining the research question. These planning stages should be conducted prior to registering study methods.Pragmatically, the scope of a systematic review

Finding relevant studies to include in a systematic review is hard.Weeks can be spent sifting through massive piles of literature to find studies matching the eligibility criteria and yet,when reporting methods of the review, these details are typically skimmed over (average reporting quality ${ < } 5 0 \%$ see Supporting Information).While authors might deem it needlessly tedious to report the minutiae of their search methods, the supplementary information can service readers who wish to evaluate the appropriateness of the search methods (e.g.‘PRESS’-Peer Review of Electronic Search Strategies; McGowan et al., 2O16).Detailing search methods is also necessary for the study to be updatable using approximately the same methods (Garner et al., 20l6). Although journal subscriptions might vary over time and between different institutions (Mann,2O15),all authors can aim for approximately replicable searches.For instance,authors searching for studies through Web of Science should specify which databases were included in their search; institutions will typically only have access to a portion of the possible databases.

To recall how and why searches were conducted, authors should record the process and workflow of search strategy development.Often,multiple scoping searches are trialled before settling on a final search strategy (Siddaway, Wood & Hedges,2O19).For this process of trial-and-error,authors can check the ability of different searches to find a known set of suitable studies (studies that meet, or almost meet, the eligibility criteria;Item 4) (Bartels，2013).Thescoping searches can be conducted using a single database,but it is preferable to use more than one database for the final search (Bramer et al.,2O18) (requiring duplicated studies to be removed prior to study selection, for which software is available；Rathbone et al.，2015a; Westgate，2019；Muka et al.,2O2O). Sometimes potentially useful records will be initially inaccessible (e.g.when authors’home institutions do not subscribe to the journal),but efforts can be made to retrieve them from elsewhere (e.g.inter-library loans; directly contacting authors) (Stewart et al., 2O13).Authors should note whether the search strategy was designed to retrieve unpublished sources and grey literature. While most meta-analysts in ecology and evolutionary biology only search for published studies, the inclusion of unpublished data could substantially alter results (Sanchez-T6jar et al., 2018).

Traditional systematic reviews aim to be comprehensive and find all relevant studies,published and unpublished, during a ‘comprehensive search’ (Primer A). In order to achieve comprehensive coverage in medical reviews, teams of systematic reviewers often employ an information specialist or research librarian.In ecology and evolutionarybiology,it is more common to obtain a sample of available studies,sourced from a smaller number of sources and/or from a restricted time period.The validity of this approach depends on whether the sample is likely to be representative of all available studies; if the sampling strategy is not biased,aiming for a representative sample is justifiable (Cote &Jennions,2O13).We encourage authors to be transparent about the aim of their search and consider the consequences of sampling decisions. Further guidance onreportingliteraturesearchesisavailable from PRISMA-S (Rethlefsen et al.， 2021)，and guidance on designing and developing searches is available from Bartels (2013), Bramer et al. (2018), Siddaway et al. (2019) and Stewart et al. (2013).

# Item 6: Study selection

Describe how studies were selected for inclusion at each stage of the screening process (e.g. use of decision trees, screening software). Report the number of people involved and how they contributed (e.g. independent parallel screening).

# Explanation and elaboration

As with finding studies, screening studies for inclusion is a time-consuming process that ecologists and evolutionary biologists rarely describe in their reports (average reporting quality ${ < } 1 0 \%$ ；see Supporting Information). Typically, screening is conducted in two stages.First, titles and abstracts are screened to exclude obviously ineligible studies (usually the majority of screened studies will be ineligible). Software can help speed up the process of title and abstract screening (e.g.Rathbone,Hoffmann & Glasziou, $2 0 1 5 b$ ；Ouzzani et al.,2Ol6). Second, the full texts of potentially ineligible studies are downloaded (e.g. using a reference manager) and screened.At the full-text stage, the authors should record reasons why each full text did not meet the eligibility criteria (Item 19).Pre-determined, documented,and piloted eligibility criteria (Item 4) are essential for both stages of screening to be reliable.Preferably, each study is independently screened by more than one person. Authors should report how often independent decisions were in agreement,and the process for resolving conflicting decisions (Littell，Corcoran & Pillai, 2Oo8). To increase the reliability and objectivity of screening criteria,especially when complete independent screening is impractical,authors could restrict independent parallel screening to the piloting stage, informing protocol development. Regardless of how studies were judged for inclusion,authors should be transparent about how screening was conducted.

# Item 7: Data collection process

Describe where in the reports data were collected from (e.g. text or figures), how data were collected (e.g. software used to digitize figures, external data sources), and what data were calculated from other values. Report how missing or ambiguous information was dealt with during data collection (e.g. authors of original studies were contacted for missing descriptive statistics, and/or effect sizes were calculated from test statistics). Report who collected data and state the number of extractions that were checked for accuracy by co-authors.

# Explanation and elaboration

Describing how data were collected provides both information to the reader on the likelihood of errors and allows other people to update the review using consistent methods. Data extraction errors will be reduced if authors followed pre-specified data extraction protocols, especially when encountering missing or ambiguous data.For example, when sample sizes were only available as a range,were the minimum or mean sample sizes taken,or were corresponding authors contacted for precise numbers? Were papers excluded when contacted authors did not provide information, or was there a decision rule for the maximum allowable range (e.g. such that $n = 1 0 { - } 1 2$ would be included, but $n = 1 0 { - } 3 0$ would be excluded)? Another ambiguity occurs when effect sizes can be calculated in multiple ways, depending on which data are available (sensibly,the first priority should be given to raw data, followed by descriptive statistics - e.g. means and standard deviations, followed by teststatistics and then $P -$ values).Data can also be duplicated across multiple publications and, to avoid pseudo-replication (Forstmeier et al., 2Ol7), the duplicates should be removed following objective criteria.Whatever precedent is set for missing,ambiguous,or duplicated information from one study should be applied to all studies. Without recording the decisions made for each scenario, interpretations can easily drift over time.Authors can record and report the percentages of collected data that were affected by missing, ambiguous,or duplicate information.

Data collection can be more efficient and accurate when authors invest time in developing and piloting a data collection form (or database),which can be made publicly available to facilitate updates (Item 18). The form should describe precisely where data were presented in the original studies,both to help re-extractions,and because some data sources are more reliable than others. Using software to extract data from figures can improve reproducibility [e.g. metaDigitise (Pick,Nakagawa & Noble, 2019) and metagear (Lajeunesse, 2016)]. Ideally, all data should be collected by at least two people (which should correct for the majority of extraction errors). While fully duplicating extractions of large data sets might be impractical for small teams (Primer B),a portion of collected data could be independently checked. Authors can then report the percentage of collected data that were extracted or checked by more than one person, error rates,and how discrepancies were resolved.

# Item 8: Data items

Describe the key data sought from each study, including items that do not appear in the main results,or which could not be extracted due to insufficient information. Describe main assumptions or simplifications that were made (e.g. categorisingboth‘length’and‘mass’ as ‘morphology'). State the type of replication unit (e.g. individuals, broods, study sites).

# Explanation and elaboration

Data collection approaches fall on a spectrum between recording just the essential information to address the aim of the review,and recording all available information from each study. We recommend reporting both data that were collected and attempted to be collected. Complete reporting facilitates re-analyses,allows others to build upon previous reviews,and makes it easier to detect selective reporting of results (Primer C).For re-analyses,readers could be interested in the effects of additional data items (e.g. species information),and it is therefore useful to know whether those data are already available (Item 18). Similarly, stating which data were unavailable,despite attempts to collect them, identifies gaps in primary research or reporting standards.For selective reporting,authors could collect a multitude of variables but present only a selection of the most compelling results (inflating the risk of false positives; Primer C). Having a registered analysis plan is the easiest way to detect selective reporting (Item 3). Readers and peer-reviewers can also be alerted to this potential source of bias if it is clear that, for example, three different body condition metrics were collected,but the results of only one metric were reported in the paper.

# VIII. PRIMER D: BIAS FROM PRIMARY STUDIES

The conclusions drawn from systematic reviews and metaanalyses are only as strong as the studies that comprise them (Gurevitch et al.,2O18). Therefore,an integral step of a formal systematic review is to evaluate the quality of the information that is being aggregated (Pullin & Stewart, 2006; Haddaway & Verhoeven, 2Ol5).If this evaluation reveals that the underlying studies are poorly conducted or biased, then a meta-analysis cannot answer the original research question.Instead,the synthesis serves a useful role in unearthing flaws in the existing primary studies and guiding newer studies (Ioannidis,2O16).While other fields emphasise quality assessment, risk of bias assessment,and/or‘critical appraisal’ (Cooke et al.， 2Ol7),ecologists and evolutionary biologists seldom undertake these steps.When surveyed, authors,reviewers,and editors of systematic reviews and meta-analyses in ecology and evolutionary biology were largely oblivious to the existence of study quality or risk of bias assessments,sceptical of their importance,and somewhat concerned that such assessments could introduce more bias into the review (see Supporting Information). In this respect, little has changed since 2OO2,when Simon Gates wrote that randomization and blinding deserve more attention in meta-analyses in ecology (Gates, 2002).

It is difficult to decide upon metrics of ‘quality’ for the diverse types of studies that are typically combined in an ecological or evolutionary biology meta-analysis. We typically consider two types of quality- internal validity and external validity (James et al., 2O16). Internal validity describes methodological rigour: are the inferences of the study internally consistent,or are the inferences weakened by limitations such as biased sampling or confounds? External validity describes whether the study addresses the generalised research question.In ecology and evolutionary biology，the strongest causal evidence and best internal validity might come from large， controlled experimentsthat use‘best practice' methods such as blinding. If we want to generalise across taxa and understand the complexity of nature,however, then we need ‘messier’ evidence from wild systems.Note that in the medical literature, risk of bias (practically equivalent to internal validity) is considered a separate and preferable construct to‘study quality’ (Büttner et al., 2O2O),and there are well established constructs such as ‘GRADE’ for evaluating the body of evidence （‘Grading of Recommendations, Assessment, Development and Evaluations'； Guyatt et al., 2008). In PRISMA-EcoEvo we are broadly referring to study quality (Item 9) until such a time when more precise and accepted constructs are developed for our fields.

In PRISMA-EcoEvo we encourage ecologists and evolutionary biologists to consider the quality of studies included in systematic reviews and meta-analyses carefully,while recognising difficulties inherent in such assessments.A fundamental barrier is that we cannot see how individual studies were conducted.Usually,we only have the authors’reports to base our assessments on and, given problems with reporting quality, it is arguable whether the authors’ reports can reliably represent the actual studies (Liberati et al., 2009; Nakagawa & Lagisz, 2019). Quality assessments are most reliable when they measure what they claim to be measuring (construct validity') with a reasonable degree of objectivity, so that assessments are consistent across reviewers (Cooke et al., 2017). Despite the stated importance of quality assessment in evidence-based medicine, there are still concerns that poorly conducted assessments are worse than no assessments (Herbison,Hay-Smith & Gillespie, 2Oo6),and these concerns were echoed in responses to our survey (see Supporting Information). Thoughtful research is needed on the best way to conduct study quality and/or risk-of-bias asessments. While internal validity (or risk of bias) will usually be easier to assess,we urge review authors to be mindful of external validity too (i.e. generalisability).

# IX.ANALYSIS METHODS

Item 9: Assessment of individual study quality Describe whether the quality of studies included in the meta-analysis was assessed (e.g. blinded data collection, reporting quality, experimental versus observational),and, if so,how this information was incorporated into analyses (e.g. meta-regression and/or sensitivity analysis).

# Explanation and elaboration

Meta-analysis authors in ecology and evolutionary biology almost never report study quality assessment, or the risk of bias within studies, despite these assessments being a defining feature of systematic reviews (average reporting quality ${ < } 1 0 \%$ , see Supporting Information; Primer D). Potentially, authors are filtering out studies deemed unambiguously unreliable during the study selection process (Item 6),but this process is poorly reported, making reproducibility impractical. A more informative approach would be to code indicators of study quality and/or risk of bias within studies, and then use meta-regression or subgroup analyses to assess how these indicators impact the review's conclusions (Curtis et al., 2013). While sensible in theory, quality assessment is difficult in practice (some might say impossible, given current reporting standards in the primary literature; Primer D).The principal difficulty is that we rely on authors’ being reliable narrators of their conduct; omiting important information, such as the process of randomization, leaves us searching in the dark for a signal of study quality (O'Boyle, Banks & Gonzalez-Mulé, 2Ol7). Uncertainty about the reliability of author reports is exacerbated by the absence of registration for most publications in ecology and evolutionary biology (Primer C). Until further research is conducted on reliable methods of quality assessment in our felds,we recommend review authors critically consider and report whether meaningful quality (or risk of bias) indicators could be collected from included studies. For example, indicators for experimental studies could include whether or not data collection and/or analysis was blinded for those collecting or analysing data [as blinding reduces the risk of bias (van Wilgenburg & Elgar,2013;Holman et al., 2015)] and whether the study showed full reporting of results [e.g. using a checklist such as Hillebrand & Gurevitch (2O13); an example of the latter is shown in Parker et al. (2018a)]. Authors should then measure the impact that quality indicators have on the review's results (Items 16 and 24). Ultimately,as with collecting studies and data (Items 5 and 7),review authors are bound by the reporting quality of the primary literature.

Item 10: Effect size measures

Describe effect size(s) used. For calculated effect sizes (e.g. standardised mean difference, log response ratio) provide a reference to the equation of each effect size and (if applicable) its sampling variance, or derive the equations and state the assumed sampling distribution(s).

# Explanation and elaboration

For results to be understandable,interpretable,and dependable,the choice of effect size should be carefully considered,and the justification reported (Harrison, 2010).For interpretable results it is essential to state the direction of the effect size clearly (e.g.for a mean difference,what was the control,was it subtracted from the treatment, or was the treatment subtracted from the control?).Sometimes,results will only be interpretable when the signs of some effect sizes are selectively reversed (i.e. positive to negative,or vice versa),and these instances need to be specified (and labelled as such in the available data; Item 18).For example,when measuring the effect of a treatment on mating success,both positive and negative differences could be‘good’ outcomes (e.g. more offspring and less time to breed)，so the signs of‘good’ negative differences would be reversed.

Choosing an established effect size (such as Hedges' $g$ for mean differences,or Fisher's $z$ for correlations) carries the advantage of the effect size's statistical properties being sufficiently understood and described previously (Rosenberg, Rothstein & Gurevitch, 2Ol3).When a non-conventional effect size is chosen,authors should provide equations for both the effect size and its sampling variance.Details should be provided on how the equations were derived, and how the sampling variance was determined (with analytic solutions or simulations) (Mengersen & Gurevitch, 2013).

Item 11: Missing data

Describe any steps taken to deal with missing data during analysis (e.g. imputation, complete case, subset analysis). Justify the decisions made.

# Explanation and elaboration

There are multiple methods to analyse data sets that are missing entries for one or more variables, therefore the chosen methods should be reported transparently. Statistical programs often default to ‘complete case', deleting rows that contain missing data (empty cells) prior to analysis,but our assessment of reporting practices found it was uncommon for authors to state that complete case analysis was conducted (despite their data showing missing values for metaregression moderator variables). Understandably,authors might not recognise the passive method of complete case analysis as a method of dealing with missing data,but it is important to be explicit about this step,both for the sample size implications (Item 2O) and because of the potential to introduce bias when data are not ‘missing completely at random’ (Nakagawa & Freckleton, 20o8; Little & Rubin, 2020). As an alternative to complete case analysis,authors can impute missing data based on the values of available correlated variables (e.g. multiple imputation methods,which retain uncertainty in the estimates of missing values; for discussion of these methods,see Ellington et al., 2015).Data imputation can be used for missing moderator variables as well as information related to effect sizes (e.g. sampling variances)，thereby increasing the number of effect sizes included in analyses (Item 2O) (Lajeunesse, 2013).Because imputation methods rely on the presence of correlated information,authors might extract additional data items to inform the imputation models,even if those data items are not of interest to the main analyses (Item 8). When justifying the chosen method, authors can conduct sensitivity analyses (Item l6) to assess the impact of missing data on estimated effects.

# Item 12: Meta-analytic model description

Describe the models used for synthesis of effect sizes. The most common approach in ecology and evolution will be a random-effects model, often with a hierarchical/multilevel structure. If other types of models are chosen (e.g. common/fixed effects model, unweightedmodel), thisrequires justification.

# Explanation and elaboration

Meta-analyses in ecology and evolutionary biology usually combine effect sizes from a broad range of studies, making it sensible to use a model that allows the ‘true’ effect size to vary between studies in a ‘random-effects meta-analysis’ (the alternative is a ‘common’ or ‘fixed'-effect meta-analysis). Both frequentist and Bayesian statistical packages can implement random-effects meta-analyses. It is also common for multiple random effects to be included in a multilevel or hierarchical structure to account for non-independence (Item 14). Traditional meta-analytic models are weighted so that more precise effects have a greater influence on the pooled estimate than effects that are less certain (Primer A).In a random-effects meta-analysis, weights are usually taken from the sum of within-study sampling variance and the betweenstudy variance.As a consequence of these variances being combined, large between-study variance will dilute the impact of within-study sampling variances. Alternatively, weights can be taken from the within-study sampling variancesalone (asisdone for common-effect models) (Henmi & Copas, 2OiO).When between-study variance is large (which can be assessed with heterogeneity statistics; Item 22), these two weighting structures could give different results.Authors could therefore assess the robustness of their results to alternative weighting methods as part of sensitivity analyses (Items 16 and 24).

Unweighted meta-analyses are regularly published in ecology and evolutionary biology journals, but we advise that these analyses be interpreted cautiously,and justified sufficiently. Theoretically,when publication bias is absent and effects have a normal sampling distribution, unweighted analyses can provideunbiasedestimates(justwithlowerprecision) (Morrissey, 2Ol6).However, it is hard to detect effects that are inflated due to publication bias without sampling variances (Item l6),and from unweighted analyses we cannot estimate the contribution of sampling variance to the overall variation among effects (i.e. heterogeneity; Item 22). Unweighted analyses become more problematic for analyses of absolute values, because the ‘folded’ sampling distribution produces upwardly biased estimates (Nakagawa & Lagisz, 2Ol6). Such analyses of magnitudes, ignoring directions, are relatively common in ecology and evolutionary biology. There are two possible correctionsforbiasfrom analysesofabsolutevalues(sensu Morrissey, 2016): $( i )$ ‘transform-analyse',where the folded distribution is converted to an unfolded distribution before analysis, or; $( \romannumeral 1 )$ ‘analyse-transform',where the folded estimates are back-transformed to correct for bias.

# Item 13: Software

Describe the statistical platform used for inference (e.g. R), and the packages and functions used to run models, including version numbers. Specify any arguments that differed from the default settings.

# Explanation and elaboration

Given the many software options and methods available for conducting meta-analyses, transparent reporting is requiredforanalysestobereproducible(Sandve et al., 20l3).Authors should cite all software used and provide complete descriptions of version numbers.When describing software, it is easy to overestimate familiarity among the readership; changes from the default settings will notbe obvious to some and should be described in full. That said, this item is less important than sharing data and code (Item 18) because shared code will convey much of the same information in a more reproducible form. Nonetheless it is helpful to describe software details in the text for the majority ofreaders who will not dig into the shared code.

# Item 14: Non-independence

Describe the types of non-independence encountered (e.g. phylogenetic, spatial, multiple measurements over time) and how non-independence has been handled, including justification for decisions made.

# Explanation and elaboration

Meta-analyses in ecology and evolutionary biology regularly violate assumptions of statistical non-independence, which can bias effect estimates and inflate precision. For example,studies containingpseudo-replication (Forstmeier et al.,2Ol7) have inflated sample sizes and downwardly biased sampling variances. When multiple effect sizes are derived from the same study, they are often not statistically independent, such as when multiple experimental groups are compared to the same control group (Gleser & Olkin, 2009). Alternatively, there may be nonindependence among effect sizes across studies. There are numerous sources of non-independence at this level, including dependence among effect sizes due to phylogenetic relatedness (discussed in Primer E),and correlations between effect sizes originating from the same population or research group (Nakagawa et al., 2O19). Despite the ubiquity of non-independence in ecological and evolutionary meta-analyses, these issues are often not disclosed in the report ( $3 2 \%$ of 102 meta-analyses described the types of non-independence encountered; see Supporting Information).We recommend that authors report all potential sources of non-independence among effect sizes included in the meta-analysis,and the proportion of effect sizes that

are impacted (for further guidance, see Noble et al., 2017;   
López-Lopez et al., 2018).

In addition to listing all sources of non-independence, authors should report and justify any steps that were taken to account for the stated non-independence. Steps range from the familiar (e.g. averaging multiple effect sizes from the same source, the inclusion of random effects,and robust variance estimation; Hedges,Tipton & Johnson, 2O1O) to the more involved (e.g. modelling correlations directly by includingcorrelation or covariance matrices)． Complicated methods of dealing with non-independence are best communicated through shared analysis scripts (Item 18). When primary studies are plagued by pseudo-replication (which could be considered in quality assessment; Item 9),an effect size could be chosen that is less sensitive to biased sample sizes (Item 10) (e.g. for mean differences, the log response ratio, InRR,rather than the standardised mean difference, $d )$ ,and (to be more conservative） sampling variances could be increased (Noble et al., 2017).

Itis not expected that non-independence can be completely controlled for.As with primary studies, problems of non-independence are complicated,and often the information necessary to solve the problem is unavailable (e.g. strength of correlation between non-independent samples or effect sizes,or an accurate phylogeny).Where there are multiple,imperfect, solutions, we encourage running sensitivity analyses (Item l6) and reporting how these decisions affect the magnitude and precision of results (Item 24).

Item 15: Meta-regression and model selection

Provide a rationale for the inclusion of moderators (covariates) that were evaluated in metaregression models. Justify the number of parameters estimated in models, in relation to the number of effect sizes and studies (e.g. interaction terms were not included due to insufficient sample sizes). Describe any process of model selection.

# Explanation and elaboration

When meta-regressions are used to assess the effects of moderator variables (i.e.meta-analyses with one or more fixed effects)，the probability of false-positive findings increases with multiple comparisons.Therefore,rationales for each moderator variable should be provided in either the introduction or methods section of the meta-analysis manuscript.Analyses conducted solely for exploration and description should be distinguished from hypothesis-testing analyses (see Item 17). Authors should also report how closely the chosen moderator variables relate to the biological phenomena of interest (e.g. using mating call rate as a proxy for mating investment),and how the variables were categorised (Item 8).

For model selection and justification, principles from ordinary regression analyses apply to meta-regressionstoo (Gelman & Carlin, 2014; Harrison et al., 2018; Meteyard & Davies,2O20). To avoid cryptic multiple hypothesis testing and associated high rates of false positive findings,authors should report full details of any model selection procedures (Forstmeier & Schielzeth, 20l1). Under-powered metaregressions should be reported with obvious caveats (or else avoided completely),to discourage the results from being interpreted with unwarranted confidence (Tipton,Pustejovsky & Ahmadi, 2O19).Meta-regressions have lower statistical power than meta-analyses, especially when including interaction terms between two or more moderator variables (Hedges & Pigott, 2OO4). Low statistical power can be due to any combination of too few available studies, small sample sizes within studies,or high amounts of variability between study effects,and therefore justification of meta-regression models should include consideration of sample sizes (Item 20)and heterogeneity (Item 22) (Valentine et al., 2010).

Item 1o: Publication bias and sensitivity analyses Describe assessments of the risk of bias due to missing results (e.g. publication, time-lag, and taxonomic biases), and any steps taken to investigate the effects of such biases (if present). Describe any other analyses of robustness of the results, e.g. due to effect size choice, weighting or analytical model assumptions, inclusion or exclusion of subsets of the data, or the inclusion of alternative moderator variables in meta-regressions.

# Explanation and elaboration

Reviews can produce biased conclusions if they summarise a biased subset ofthe available information,or ifthere is bias within the information itself.Authors should therefore assess risks ofbias so that confidence in the conclusions (orlack thereof) canbe accurately conveyed. Bias within the information itself was discussed in Item 9 and Primer D.Publication bias occurs when journals and authors prioritise the publication of studies with particular outcomes.For example, journals might prefer studies that support an exciting hypothesis,rather than publishing null or contradictory evidence (Rosenthal, 1979; Murtaugh, 2002; Leimu & Koricheva, 2OO4). Meta-analyses in ecology and evolutionary biology typically rely on published papers for data (Item 5) and hence are especially vulnerable to the effects of publication bias (e.g. Sanchez-Tojar et al., 2O18).Even if al research was published, the resulting papers would still provide information that was biased towards certain taxa (e.g. vertebrates), geographical locations (e.g. field sites close to Western universities),and study designs (e.g. short-term studies contained within the length of a PhD) (Pysek et al., 2008; Rosenthal et al., 2017). Such ‘research biases'(Gurevitch & Hedges,l999) should be considered when categorising studies (Item 8).

While none are entirely satisfactory,multiple tools are available to detect publication bias in a meta-analytic data set (Moller & Jennions, 20O1; Parekh-Bhurke et al.,2O11; Jennions et al., 2O13).Many readers will be familiar with funnel plots,whereby effect sizes (either raw, or residuals) are plotted against the inverse of their sampling variances,which should form a funnel shape.Asymmetries in the funnel indicate studies that are ‘missing' due to publication bias, but could also be a benign outcome of heterogeneity (Item 22) (Egger et al.,1997; Terrin et al., 2003). Although funnel plots and Egger's regresson (a test of funnel plot asymmetry) were originally only useful for common-effect meta-analytic models (Egger et al., 1997),modified methods have been proposed to suit the random-effects meta-analytic models commonly used in ecology and evolutionary biology (Item 12; Moreno et al., 2009; Nakagawa & Santos, 2012). Publication bias might also be indicated by a reduction in the magnitude of an effect through time (tested with a metaregression using publication year as a moderator,or with a cumulative meta-analysis) (Jennions& Moller, 2002; Leimu & Koricheva, 2004; Koricheva & Kulinskaya, 2019). When biases are detected,we recommend authors report multiple sensitivity analyses to assess the robustness of the review's results (Rothstein， Sutton & Borenstein,2005; Vevea, Coburn & Sutton, 2O19). Subgroup analyses can be reported to test whether the original effect remains once the data set is restricted to recent studies,or studies that have been assessed to have a lower risk of bias (Item 9).To assess the sensitivity of the results to individual studies,authors can also report ‘leave-one-out’ analyses,and plot variability in the primary outcome (Willis & Riley, 2017).

# Item 17: Clarifcation of post hoc analyses

# When hypotheses were formulated after data analysis, this should be acknowledged.

# Explanation and elaboration

Usually,a hypothesis should only be tested on data that were collected with the prior intention oftesting that hypothesis.While a meta-analysis can test different hypotheses from those addressed in primary studies on which it is based, it is important that these hypotheses are formulated in advance. It is common, however,for researchers to be curious aboutpatterns in their data after they have already been collected. Exploration and description are integral to research, but problems arise when such analyses are presented as hypothesis-testing, especially when they deviate from what is statedina registration(also called‘Hypothesising After Results are Known’—see Primer C; Kerr,1998). Ideally,authors willhave a registeredanalysis plan (Item 3) to protect against the common self-deception that a post-hoc analysis was， in hindsight,the obviousa-priori choice(Parker et al.,2O16a).When a public registration is not provided, the reader is reliant on the memory and honesty of the authors.It is currently rare to see post-hoc acknowledgements in ecology and evolution meta-analyses (or indeed in primary studies) but, in the methods section, we encourage authors to state transparently which analyses were developed after data collection and, in the discussion, temper confidence in the results of such analyses accordingly.

# Item 18: Metadata, data, and code

Share metadata (i.e. data descriptions), data, and analysis scripts with peer-reviewers. Upon publication, upload this information to a permanently archived website in a user-friendly format. Provide all information that was collected, even if it was not included in the analyses presented in the manuscript (including raw data used to calculate effect sizes, and descriptions of where data were located in papers). If a software package with graphical user interface (GUI) was used, then describe full model specification and fully specify choices.

Explanation and elaboration

Sharing data, metadata, and code scripts (or equivalent descriptions)is the only way for authors to achieve ‘computational reproducibility' (the ability to reproduce all results presented in a paper)(Piccolo & Frampton,2Oi6).Data,metadata and code files also preserve important information in a format that some readers will find easier to understand than wordysummaries (e.g. descriptions of statistical methods). Thanks to a decadal shift in journal policies to mandate data sharing, this is one aspect of reporting where ecological and evolutionary biology metaanalyses are ahead of medical felds (Roche et al., 2O15; Sholler et al., 2O19). During this coming decade our community can raise the bar higher by mandating sharing of metadata and analysis scripts (or complete descriptions of workflow for point-and-click software). We strongly encourage authors to provide data in a user-friendly file format [such as a .csv file rather than a table in a .pdf or .doc file; see also the ‘FAIR'principles by Wilkinson et al. (2016),urging fordata tobe findable,accessible, interoperable,and reusable]. Currently, more than half of meta-analyses in ecology and evolution share data without corresponding metadata (ie. complete descriptions ofvariable names; se Supporting Information),and this can render the data itselfunusable.Authors should also consider sharing other materials that, in a spirit of collegiality, could be helpful to other researchers (e.g.bibliographic files from a systematic search; Item 5).

Data and code should be provided from the peer-review stage (Goldacre,Morton & DeVito, 2019) (for double-blind reviews, files can be anonymised). Currently, the requirement by most journals in ecology and evolutionary biologyfor data to be shared upon publication reduces this important task to an afterthought. We recognise that many peer-reviewers, who are already overburdened,will not check computational reproducibility.But some will,and this background level of accountability should improve the standards of authors,who are ultimately responsible for the trustworthiness of their work. From our experiences, the analyses described in papers can differ markedly from what is contained in the code,and data collection and processing mistakes are common.Evidence from other fields suggests that data and/or code provided by authors often do not reproduce the results presented in a paper (Nosek et al., 2O15; Stodden, Seiler & Ma, 2018). For ful transparency and computational reproducibility,authors should provide raw and pre-processed data and the accompanying scripts (Sandve et al.，2O13；Piccolo & Frampton, 2Ol6).That way,the pipeline of data tidying,calculations (including effect size calculations),and any outlier exclusions can be reproduced.Rather than uploading these materials as static files along with the supplementary materials, which might not be stored permanently,we recommend authors create an active project repository (e.g. on the Open Science Framework) so that, if the authors wish, the materials and code can be improved (e.g. ifreaders spot small mistakes).

Occasionally it might be justifiable to withhold raw data (e.g. due to confidentiality or legal issues, or if future projects are planned with the data).In such a case,a dummy data set,approximately replicating the real data, could be made available to peer-reviewers along with analysis scripts. Because meta-analyses in ecology and evolutionary biology typically summarise published studies,which are unlikely to contain ethically sensitive information (such as precise locations of endangered species), it is exceedingly rare that withholding data past an embargoed date is justifiable.Aiming for computational reproducibility can be burdensome but,increasingly,these efforts should be viewed favourably by academic reward systems (Moher et al.,2O18).Rewards aside,as authors ofreviews we should practice what we preach.When collecting data for a metaanalysis,much time is wasted in frustration when data are not adequately reported in published papers,and requests for data from authors have varying succes (Item 7). Archiving data from primary studies in an online repository would make the data collection process far easier, faster and more accurate.If we wish this practice from authors of the primary studies that systematic reviews and meta-analyses are reliant upon, then we should hold ourselves to the same standard.

# X. PRIMER E: PHYLOGENETIC NONINDEPENDENCE

Meta-analyses in ecology andevolutionarybiology often encounter phylogenetic non-independence (or relatedness). Phylogenetic non-independence - a special type of statistical nonindependence - occurs because we usually combine data originating from different species, whose evolutionary history causes them to be related to each other to varying extents (i.e. each species is not an independent unit) (Noble et al., 2O17).Phylogenetic signal in a meta-analytic data set may impact the outcome of the analysis (Chamberlain et al.,2Ol2). In many cases we can model phylogenetic non-independence by converting a phylogenetic tree into a correlation matrix,which describes relationships among species in the data set. The matrix can then be incorporated into the meta-analytic model, which becomes a ‘phylogeneticmeta-analysis’(Adams, 2Oo8;Lajeunesse, 2009; Hadfield & Nakagawa, 2O1O). A phylogenetic meta-analysis is mathematically identical to a phylogenetic comparative model that accounts for sampling error in the measured traits (Nakagawa & Santos, 2012).

Advances in phylogenetic comparative methods and software have made it superficially easy to incorporate phylogeny into meta-analytic models,but the particulars of the methods are contestable. Phylogenetic trees vary inqualityandrelyonsimplifyingassumptions (e.g. Brownian motion model of evolutionary divergence) (Harmon, 2O18).When a meta-analysis combines data from a diverse collection of species, it becomes harder to resolve deep phylogenetic relationships,and some species might be excluded from existing trees (resulting in incomplete data). One solution to uncertainty in individual trees isto incorporate multiple trees into the analyses (Nakagawa & de Villemereuil, 2Ol9). Once you have a tree, there are different methods -corresponding to different models of evolution -to convert the relationships into a correlation matrix (Nakagawa & Santos, 2Ol2). Given that phylogenetic comparative methods remain an active area of research and different analysis assumptions could lead to different outcomes,authors could present results from multiple analyses as part of sensitivity analyses (Item 24) (and whether or not a meta-analytic data set contains a phylogenetic signal is itself a potentially revealing outcome).Regardless of how authors choose to handle phylogenetic non-independence,transparency is essential fora phylogenetic meta-analysis to be reproducible (Borries et al., 2016).

# XI. REPORTING RESULTS

# Item 19: Results of study selection process

Report the number of studies screened, and the number of studies excluded at each stage of screening (with brief reasons for exclusion from the fulltext stage). Present a Preferred Reporting Items for Systematic Reviewsand Meta-Analyses (PRISMA)-like flowchart (www.prisma-statement.org).

# Explanation and elaboration

Without knowing the number of studies found (Item 5) and screened (Item 6),and the reasons why full-text articles were excluded, the reliability of a systematic search is unclear.The flow-chart template,originally provided by PRISMA in 2009 and modified in 2O2O,presents this information in a concise and consistent format,and it is the aspect of PRISMA that is most commonly referenced by meta-analysis authors in ecology and evolutionary biology (see Supporting Information).Conceptual examples of PRISMA flowcharts are shown in Fig. 3; authors can customise the flowchart as they please,but the following should be presented: (i) the number of records that originated from each source of information; $( i i )$ the number of records after duplicates were removed; (ii) the number of full texts screened; (iu) the tallied reasons why full texts were excluded; and $( v )$ the total number of studies included in the systematic review and meta-analysis (which might differ),and the number of effect sizes.Tracking these five details during the search and screening process requires conscientious workflows. In addition,as recommended in the updated PRISMA flow diagram,authors could list the number of records that were removed by machine learning classifiers,and the number of full texts that could not be retrieved. While the flowchart summarises why full texts were excluded, for full accountability we recommend that authors provide the references of all articles excluded at the full text stage,alongside reasons for their exclusion.

# Item 20: Sample sizes and study characteristics

Report the number of studies and effect sizes for data included in meta-analyses, and subsets ofdata included in meta-regressions. Provide a summary ofkey characteristics for reported outcomes (either in text or figures; e.g. one quarter of effect sizes reported for vertebrates and the rest invertebrates)

![](images/1ae190cce9078b127177212fc9086229d9bcff0a77c0d1eb43cf53d3b4c10824.jpg)  
Fig3.PRISMA-stylefowchartsandsomevariations. (A)Theclasicfow-chart: allsearches areconductedaroundthesamedate, andscreeningoccursafterde-duplication.(B)Recordsareobtained fromdiferentdatabases (orothersources,e.g.personal archives orrequests)andscreened separately.De-duplication occursafteratleastonestageof screening. (C)The studies incuded afteraclassicsearcharethenusedasthe‘seedforanewsearchasedoncitationinformation.Authorscanretrieveallpapers cited n includedartices backwardssach)ndallpapersthatcitethencudedarticles (frwardssarch).Ascodroudfdeduplication and screening then occurs.(D)Whena systematicreview isanupdateof an already existing one,the newly found papersareaddedtothexistingold)setofcludedppers.Asafurtherextensionitouldbebenefial tecord,dort, how manyof the included articlesoriginate from each source.For example,ifonedatabasecontributednoneof the included articles,then updates of the review could save time by not screening articles from that database.

# and their limitations (e.g. collinearity and overlaps between moderators)， including characteristics related to individual study quality (risk of bias).

# Explanation and elaboration

Meta-analyses and meta-regressions cannot answer questions for which there are no,or almost no,data available. It is therefore essential to report complete sample sizes for every analysis that was conducted (these can be reported in supplementary tables, if brevity is required).Authors should provide sample sizes for the number of studies (or equivalent unit of analysis) because, for example, it would be misleading to withhold that a sample size of $k = 2 0$ effect sizes originated from only $n = 2$ studies.Figures or tables can be used to report sample sizes concisely across multiple hierarchical levels of meta-analyses, as well as across and within different moderator variables included in meta-regressions [e.g. see fig. 3 in Lagisz et al. (2O2O) and table l in Chaplin-Kramer et al. (2011)].

When presenting results from meta-regressions,authors should report complete case sample sizes for moderators containing missing data (Item l1) and, in the case of categorical (i.e.discrete) moderators,sample sizes for all included categories. In meta-regressions with more than one moderator it is important to consider the extent to which moderator variables overlap. In the case of multiple categorical variables,authors should report sample sizes across all possible combinations of categories. For example,in a metaregression including the interaction between ‘vertebrate or invertebrate’and ‘urban or wild’moderator variables, authors could report $n = 8$ studies on invertebrates were divided into $n = 6$ studies in urban environments,and $n = 2$ in wild environments,while $n = 2 0$ studies on vertebrates were evenly split with $n = 1 0$ studies in each category of urbanisation. When reporting meta-regressions with both continuous and categorical moderators,we recommend reporting the amount of coverage of the continuous moderator within each category using descriptive statistics or data visualisations (e.g. when including the continuous fixed effect of study year,authors should report whether studies conducted in‘urban' and ‘wild' environments spanned a similar time period).

It is important to report sample sizes comprehensively so that the risk of inaccurate parameter estimates can be evaluated.Statistical power in a random-effects meta-analysis (Item l2),with a single random effectfor studyidentity,is influenced by: the number of included studies and sample sizes within them (i.e.number of independent effect sizes and their precision); the amount of variation in effects between studies; the (pre-specified) size of the ‘true’ effect being investigated; and the accepted probability of falsely rejecting the null hypothesis (conventionally set at alpha $= 0 . 0 5$ for ecological and evolutionary analyses) (Valentine et al., 2O1O). Statistical power is always lower for estimates ofmoderating effects compared to the meta-analytic mean, and much lower for estimates of the interaction between multiple moderating effects (Hedges & Pigott, 2OO4).Power calculations are further complicated by uneven sampling within studies and multiple types of statistical non-independence (as is common in ecology and evolutionary biology; Item l4). Data simulations are usually required to estimate the probability of false-positive results for these complex analyses [for further guidance on these issues,see Gelman & Carlin (2014), Tipton et al. (2019) and Valentine et al. (2010)].

A key feature of any review is to summarise what research has been conducted and highlight gaps in the literature. For broad topics this can be the sole purpose of the review. For example, ‘systematic maps' take a snapshot of the current state ofresearch, and ‘bibliometric maps’ chartafield's development by analysing publication and citation histories (Nakagawa et al., 2O19). The topics summarised by meta-analyses might be comparatively narrow,but their results are still context-dependent; for example, if all available studies were on temperate bird species it would be misleading to generalise about fish,or even tropical birds (Pysek et al., 2Oo8). Most ecology and evolution meta-analyses contain too many studies for the characteristics of each individual study to be conveyed to the reader.Authors could therefore adopt some ‘mapping' tools (e.g.Haddaway et al., 2O19) to distil the key characteristics of their data set in a concise (and sometimes beautiful)

format and summarise the magnitude and direction of research biases (Item 16).

Item 21: Meta-analysis

Provide a quantitative synthesis of results across studies, including estimates for the mean effect size, with confidence/credible intervals.

# Explanation and elaboration

The meta-analytic mean and associated confidence interval can be provided in the text or displayed graphically. For some questions the primary outcome will be slopes or contrasts from meta-regressions (Item 23),and the meta-analytic mean or its statistical significance might not be biologically interesting (e.g.for analyses of absolute values). In those cases,authors can justify not displaying the meta-analytic mean.

Item 22: Heterogeneity

# Report indicators ofheterogeneity in the estimated effect (e.g. $\scriptstyle { \pmb { I } } ^ { 2 }$ , tau² and other variance components).

# Explanation

Statistical heterogeneity in a meta-analysis describes variation in the outcome between studies that exceeds what would be expected by sampling variance alone.When heterogeneity is high, meta-regressions can be run to see whether moderator variables account for some of the unexplained variation in outcomes. It is trickier to quantify heterogeneity for multilevel models (which are commonly used to account for non-independence; Item 14), but methods are available (Nakagawa & Santos, 2Ol2). For unweighted meta-analyses (Item 12) it is not possible to quantify heterogeneity as properly defined, but residual errors can be used as a surrogate (as sampling errors will be absorbed into the residual error component). High heterogeneity is the norm in ecology and evolution meta-analyses (Primer B; Senior et al., 2O16). Given that we usually summarise studies that differ in multiple ways, it is surprising and notable to find an effect with low heterogeneity (e.g. Rutkowska, Dubiec & Nakagawa, 2013). Opinions differ on the most informative heterogeneity statistics,and the best way to report them.In addition to presenting a single summary of heterogeneity for a meta-analysis, it might be beneficial to estimate heterogeneity on subsets of studiesthatareconsideredmorehomogeneous (as characterised in Item 2O). Authors can also present prediction intervals alongside confidence/credible intervals, to capture uncertainty in the predicted effect from a future study (IntHout et al., 2O16; Nakagawa et al., 2020).

# Item 23: Meta-regression

Provide estimates of meta-regression slopes (i.e.regression coefficients) for all variables that were assessed for their contribution to heterogeneity. Include confidence/credible intervals,and report interactions if they were included. Describe outcomes from model selection, if done (e.g. $\scriptstyle { { \pmb R } } ^ { 2 }$ and AIC).

# Explanation and elaboration

Meta-regressons test whether a given variable moderates the magnitude or direction of an effect, and can therefore provide ‘review’or‘synthesis-generated’evidence (Cooper， 2009;

Nakagawa et al., 2Ol7). Moderator variables can be biological (e.g. sex), methodological (e.g. experimental design; Dougherty & Shuker, 2Ol5),and sociological (e.g. publication status; Item 24; Murtaugh, 2OO2).Authors should distinguish between results from exploratory and hypothesis-testing models (Item 15 and Item l7), with the latter requiring complete reporting of the number of tests that were run (so that the false-positive discovery rate can be adjusted for multiple comparisons) (Forstmeier et al., 2Ol7).When justifying the choice of model, authors can present statistical parameters of model fit (e.g. $R ^ { 2 }$ and information criterion e.g.Akaike Information Criterion (AIC)and Deviance Information Criterion (DIC)].When meta-regressions are run,authors can present $\mathcal { Q }$ statistics to quantify whether moderator variables account for significant heterogeneity (Item 22).Model selection is a difficult and debated topic (Dennis et al., 2O19),but all methods share the principle of transparently reporting outcomes.

Authors should provide all estimates from all models (i.e.complete reporting),to avoid the‘Texas sharpshooter fallacy' (whereby someone randomly fires many gunshots at a barn, paints a target around the tightest cluster,and then claims they are a good shot; Evers, 20l7) (Primer C; Item 3; Item l7). Complete reporting will often require supplementary tables (especially for extensive sensitivity analyses; Item 24). Figures are an effective way to communicate the main results from meta-regressions.For categorical moderator variables, it is common to plot the estimate of each category's intercept， with whiskers representing confidence (or credible) intervals (showing uncertainty in the mean effect for a given category). Authors can also include prediction intervals — showing uncertainty in the value of effect sizes from future studies — which provide intuitive displays of heterogeneity (Item 22) (for further ideas on displaying prediction intervals,see Nakagawa et al.,2O2O).For categorical variables with more than two levels,authors who wish to make inferences about the differences between mean estimates('intercepts'） should report the precision of all ‘slopes' or‘contrasts', not just the contrast from one baseline category. Continuous moderator variable slopes can be displayed on top of a scatterplot or, better yet, a ‘bubble plot’ of raw effect sizes (in a bubble plot, the size of points can represent weights from the meta-regression model; Lane et al., 2012).

# Item 24: Outcomes of publication bias and sensitivity analyses

Provide results for the assessments of the risks of bias (e.g. Egger's regression, funnel plots) and robustness of the review's results (e.g. subgroup analyses, meta-regression of study quality, results from alternative methods of analysis, and temporal trends).

# Explanation and elaboration

Results from meta-analyses need to be considered alongside the risk that those results are biased,due to biases either across or within studies (i.e.publication bias,or problems with the included studies).When authors find evidence of bias,they should estimate the impact of suspected bias on the reviews results (i.e.robustness of results; Item 16).More generally,authors should consider if their results are robust to subjective decisions made during the review, such as: eligibility criteria (Item 4)； data processing (including outlier treatment and choice of effect size; Item 1O);and analysis methods (including how non-independence was handled; Items 12 and 14). There are usually multiple justifiable ways to conduct a meta-analysis: each subjective decision creates an alternative path, but results are robust when many paths lead to the same outcome (Palpacuer et al., 2O19). Multiple sensitivity analyses will generate an abundance of information that can be presented within the supplementary information.

# XII. DISCUSSION AND CONTRIBUTIONS

# Item 25: Discussion

Summarise the main findings in terms of the magnitude of effects, their precision (e.g. size of confidence intervals, statistical significance), their heterogeneity, and biological/practical relevance. Compare results with previous reviews on the topic, if available.Discuss limitations and their influence on the generality ofconclusions, such as gaps in the available evidence (e.g. taxonomic and geographical research biases).

# Explanation and elaboration

There are six notes that we think authors should hit in their discussions,while allowing for variety in personal styles and journal requirements.First and second, both the magnitude and precision of the main results should be discussed. Some readers will skip straight from the introduction to the discussion，so it should be clear whether the effects being discussed are small or large, and whether they have been estimated with confidence. Third, do not ignore variation among studies when summarising aggregated results (i.e. discuss heterogeneity; Item 22).Fourth, put the results into a wider biological context (or state if the available evidence does not provide one; do not overreach). Such discussions can include the generation of testable hypotheses from exploratory analyses (Item 17). Fifth,discuss how the results of previous reviews or influential studies are strengthened or undermined by the current evidence.Sixth,discuss limitations of the current research,caused by either the methods of the review itself, or the information that was available from the primary literature.Limitations in the primary literature can refer to both the quality of individual studies (Primer D),and knowledge gaps (research biases; Item 20),both of which can be addressed by future research. Conversely,authors could identify types of studies that have been sufficiently common such that that future resources would be better spent elsewhere.

Item 26: Contributions and funding Provide names, affiliations, contributions,and all funding sources of all co-authors. Provide

# contact details for the corresponding author. Disclose any conflicts of interest.

# Explanation and elaboration

The corresponding author should provide an email address with no intended expiry date (institutional email addresses might expire when authors leave the institution). The recent uptake in the author identifier ORCID has made it easier to contact authors when their corresponding email address changes (or to contact co-authors when the corresponding author is no longer available). In medical felds,systematic reviews are regularly financed by private companies that might have financial conflicts of interest in the review's conclusions. When such external and financial conflicts of interest are present (which is conceivable for applied topics in ecology and evolutionary biology) it is expected they are disclosed. Currently, it is not common to disclose internal conflicts of interests, such as the professional benefits authors expect from publishing a highprofile review paper. For contributions statements,authors usually only list their contributions when there is a dedicated section in the journal, but we encourage authors to take it upon themselves to precisely state their contributions in the methods or acknowledgements sections (Ewers et al.，2Ol9) (see also ‘CRediT’- Contributor Roles Taxonomy; Holcombe, 2019).

# Item 27: References

Provide a reference list of all studies included in the meta-analysis. Whenever possible, list included studies as referenced sources (e.g. rather than listing them in a table or supplement).

# Explanation and elaboration

Studies included in a review article should be cited, so that they appear in the citation counts of scientific databases, to ensure that authors of primary studies are credited for their contribution (Kueffer et al.,2O11).For authors of primary studies, it can be frustrating to have their hard work included in reviews but not cited,as most commonly occurs when sources for a meta-analysis are listed in a table or the supplementary information.To give primary studies their due credit, studies included in the review can either (i) be included in the main reference list of the paper,and indicated by an asterisk (or other symbol) to distinguish them from papers cited elsewhere in the review; or () be listed in a secondary reference list that appears at the bottom of the journal article.The latter option has the advantage of delineating between studies included in the meta-analysis and studies that are cited in the text (e.g.Li et al., 2O1O; Kinlock et al.,2O18),while allowing all studies to be correctly indexed within citation databases. Recognising this choice is not always available to authors,we encourage journals,and editors of review articles, to require all studies included in a meta-analysis be included in the main reference list, or else to ensure that citations in supplementary information are appropriately indexed.

# XIII. HOW AND WHY TO USE PRISMA-ECOEVO

We aim for PRISMA-EcoEvo to help the ecology and evolution community raise the quality of reporting in systematic reviews and meta-analyses. Improved reporting in review articles is in the best interests of everyone.For authors of reviews, it willbecome easier to build upon earlier work; published methods and materials will make it easier to conduct both original reviews and update old ones. Clear reporting will help editors and reviewers provide reliable assessments of meta-analysis manuscripts.For the fields of ecology and evolutionary biology as a whole,well-reported systematic reviews provide clarity on what research has been done, what we can and cannot say with confidence,and which topics deserve attention from empiricists.

The PRISMA-EcoEvo checklist is available to download at https://osf.io/t8qd2/,and as an interactive web application at https://prisma-ecoevo.shinyapps.io/checklist/.Theweb application allows for automatic reporting quality assessments that are consistent with those detailed in the Supporting Information.Over time,PRISMA-EcoEvo can be updated to reflect improved reporting standards; users can provide feedback for an update by going to https://doi.org/lo.17605/ OSF.IO/GB5VX and following the instructions therein.

# (1） PRISMA-EcoEvo for authors

Authors of systematic reviews and meta-analyses in ecology and evolutionary biology could make use of PRISMAEcoEvo at any stage.Most of the items can be profitably planned ahead of time and registered in a time-stamped public repository or submitted to a journal as a registered report (Primer C； see also PRISMA for Protocols; Moher et al.,2Ol5).When conducting a systematic review and meta-analysis, heeding the checklist items will help with organisation and project management, as PRISMA-EcoEvo provides a guide for which pieces of information should be tracked and recorded. For in-depth conduct guidance, review authors should consult more specialised resources, many of which are cited in the items above. Once a systematic review and meta-analysis is completed and is being prepared for submission to a journal，PRISMA-EcoEvo provides a checklist for authors on what to report in their manuscript. Checklists are useful tools as they reduce cognitive burdens (Parker et al.， 2O18b). Conscientious authors could assist reviewers by submitting the checklist alongside the key location for each item. When items are not applicable for their study,authors can provide a brief explanation. Upon first reading the checklist, the amount of detail and information might overwhelm some authors,but items that appear out of reach can be considered stretch goals (i.e. things to aim for in the future). We do not expect any authors,including ourselves,to achieve every item all at once,but we aim to make small improvements over time. Even if every manuscript reported only one extra item, we would raise reporting standards for the whole field.

# (2) PRISMA-EcoEvo for reviewers and editors

Editors and reviewers of meta-analyses in ecology and evolutionary biology can use PRISMA-EcoEvo as a checklist for complete reporting and transparency in the manuscripts they assess. Peer-reviewers should feel empowered to request additional information from authors, including data and analysis scripts.When we assessed reporting quality in the current meta-analytic literature (detailed in the Supporting Information)， it was impossible to evaluate multiple aspects of reporting quality haphazardly; typically some items were reported well and others poorly, so different aspects of reporting (i.e.items on the checklist) needed to be assessed systematically. Journals could reduce the burden on reviewers by requesting authors to submit a completed PRISMA-EcoEvo checklist alongside their manuscript (as is done in many medical journals). Importantly,a poorly reported manuscript does not mean that the study itself was poorly conducted, but to be able to work out the quality of a study,reporting quality needs to be high.

# (3) Valuing permanent online repositories

For PRISMA-EcoEvo to be effective,authors will need to report information supplementary to the main paper. The legacy of print journals engendered brevity in papers, which remains, in part, for the benefit of the typical reader who does not want, or need, the tedium of complete reporting.Permanent, findable,and accessible online repositories are therefore essential for those readers who want to know the basis for the conclusions of a review article. Our survey of reporting standards suggested supplementary resources are currentlyunder-used(data ‘shown in theSupporting Information)，especially given that free and permanent online repositories remove the barriers previously imposed by journals (such as finite archiving and fees). The community may need to undergo a cultural shift to better appreciate and value materials supplementary to the main paper. Currently,authors might understandably feel the time spent preparing such materials does not return adequate benefits, but this could change if editors and reviewers request the additional information,and if supplementary materials are cited independently of the main text (Moher et al.,2O18)(the materials can have their own DOI through platforms such as the Open Science Framework).

# (4) Comparisons with PRISMA-2020

PRISMA-EcoEvo continues a long and valuable tradition of meta-analysts in ecology and evolution learning from practices in evidence-based medicine.To improve review methods, we often look towards medical fields for inspiration, as they are continually improving (due to both more researchers,funding,and stakeholders)．PRISMA-2020 requests greater reporting detail than the original PRISMA checklist did, and we encourage systematic review and meta-analysis authors in ecology and evolution to read the updated statement paper (Page et al., 2O2lb) as well as the explanations and elaborations (Page et al., 2O2la).In comparing our respective fields,ecology and evolutionary biology currently lags furthest behind in review registration (Primer C) and assessing individual study quality (Primer D). Both these areas are currently contentious (as voiced by respondents to our survey; see Supporting Information), but we hope to see improvements spurred by PRISMAEcoEvo. Two areas where ecology and evolution might be ahead of some medical fields are in the consideration of statistical non-independence (because our data are often more‘complex'),and data sharing.We can further strive to improve the useability of our shared data (e.g.with better metadata),and lift code sharing to match the level of data sharing.

# XIV. CONCLUSIONS

(1） Systematic reviews and meta-analyses are vital contributions to research fields when conducted well.However,when conducted poorly,erroneous conclusions can mislead readers. Transparent and complete reporting of these studies is therefore required, both so that confidence in the review's results can be accurately assessed,and to make the review updatable when new information is published.

(2) Evidence suggests that reporting guidelines and checklists improve reporting quality. PRISMA, the most-cited guideline,was developed for reviews of medical trials.Multiple extensions of PRISMA have already been published to suit different types of reviews,but until now there has not been a checklist specifically designed for ecology and evolution metaanalyses. Having explanations and examples targeted at the ecology and evolutionary biology community should increase uptake of the guideline in this field.   
(3) We created an extension of PRISMA to serve the ecology and evolution systematic review and meta-analysis community:version1.0ofPRISMA-EcoEvo. PRISMA-EcoEvo is a 27-item checklist that outlines best reporting practices as they currently stand.   
(4)Authors, editors,and reviewers can use PRISMAEcoEvo for systematic review and meta-analysis publications(both traditional papers,and registered reports).Authors can use it before,during,and after conducting a review to assist with recording and reporting aims,methods,and outcomes.Editors and reviewerscan use PRISMA-EcoEvo to increase reporting standards in the systematic review and meta-analysis manuscripts they review.   
(5) Collectively， themeta-analysiscommunitycan improve reporting standards by including (and requesting more PRISMA-EcoEvo items in the manuscripts they prepare,and review, over time.Research will be more efficient and effective when published reviews are transparent and reproducible.

# XV. ACKNOWLEDGEMENTS,AUTHOR CONTRIBUTIONS AND DATA AND CODE AVAILABILITY

Data collection for this project was funded through Australia Research Council Discovery Grants: DP180100818 to S.N., and DP190100297 to M.D.J. We are grateful to 208 anonymous members of the ecology and evolution meta-analysis community for providing feedback on PRISMA-EcoEvo during its development. We thank Alison Bell and Bob Wong for providing feedback on earlier drafts ofboth the main text and supporting information,and two anonymous reviewers for their constructive comments on the submitted manuscript. Finally, we are grateful to the Cambridge Philosophical Society for making this article open access.

Author contributions: conceptualisation: R.E.O, M.L., M.D.J., J.K., D.W.A.N., T.H.P., J.G., M.J.P., G.S, D.M., S.N.; data curation: R.E.O.; formal analysis: R.E.O.; funding acquisition: S.N.； investigation: R.E.O.， M.L., M.DJ.， J.K.， D.W.A.N., T.H.P, S.N.； methodology: R.E.O.; project administration: R.E.O.， S.N.； software: R.E.O.； supervision: D.M.， S.N.; visualisation: R.E.O, M.L.; writing - original draft: R.E.O.; writing - review & editing: R.E.O.， M.L.， M.D.J., J.K., D.W.A.N., T.H.P., J.G., MJ.P., G.S., D.M., S.N.

Data and code availability: data and code for the assessment of reporting standards and survey of community attitudes are available from http://doi.org/10.17605/OSF. IO/2XPFG

# XVI. REFERENCES

Referencesmarkedwithanasterisk(\*)wereincluded intheassessmentofreportingquality.Thesymbolt identifiesadditional referencesthatarecitedinthe onlinesupportinginformation.\*ABE,J.& KAMIMURA,Y. (2Ol2).Do female parasitoid wasps recognize and adjust sex ratios to build cooperative relationships?Journal of Evolutionary Biology 25,1427-1437.   
ACZEL，B.，SZASZI，B.，SARAFOGLOU，A.，KEKECS，Z.，KUCHARSKY，S., BENJAMIN，D.，CHAMBERS，C.D.，FISHER,A.，GELMAN，A., GERNSBACHER,M.A., IOANNIDIS,J. P.,JOHNSON,E.,JONAS,K., KOUSTA, S., LILIENFELD,S.O.,et al. (2O2O).A consensus-based transparency checklist. Nature Human Behaviour 4,4-6.   
ADAMs,D.C.(20o8).Phylogenetic meta-analysis. Evolution 62,567-572.   
ALLEN, C.& MEHLER,D.M.A.(2O19).Open science challenges, benefits and tips in early career and beyond.PLoS Biology 17,e3000246.   
\*AMAT,F.& MEIR, S.(2Ol7).Geographical, climatic and biological constraints on ageatsexual maturityinamphibians.Biological Journal of theLinnean Society123,34-42.   
\*BARRIENTos,R.(2Ol5).Adult sex-ratio distortion in the native European polecatis related to the expansion of the invasive American mink.Biological Conseruation186,28-34.   
\*BARRIO,I.C.,HIK,D.S.,BUENO,C.G.& CAHIL,J.F.(2O12).Extending the stresgradient hypothesis - is competition among animals less common in harsh environments? Oikos 122, 516-523.   
BARTELs,E.M.(2O13).How to perform a systematic search.Best PracticeResearch in ClinicalRheumatology27,295-306.   
\*BARTO,E.K.&RILLIG,M.C.(201O).Does herbivory really suppress mycorrhiza? A meta-analysis.Journal of Ecology 98,745-753.   
\*BARTON,K.E.& KoRICHEVA,J. (2OlO). The ontogeny of plant defense and herbivory: characterizing general patterns using meta-analysis.The American Naturalist 175,481-493.   
\*BATARY,P.，BALDI,A.，KLEIJN,D.& TSCHARNTKE,T.(2O11).Landscapemoderated biodiversity effects of Agri-environmental management:a metaanalysis.Procedings of theRoyal SocietyB:Biological Sciences278,1894-1902.   
\*BATEMAN,D.C.&sHOP,M.J.(2017).Theenvironmentalcontextandtraitsof   
habitat-formingialesincetmagideofheiosig MarineEcologyProgressSeries563,91.   
BEGG,C.B.& MAzUMDAR,M.(1994).Operating characteristics of a rank correlation test for publication bias.Biometrics 50,l088-1101.   
BELLER,E.M.,GLASZIOU,P.P.,ALTMAN,D.G.,HOPEWELL,S.,BASTIAN,H., CHALMERS,I.,GOTZSCHE,P.C.,LASSERSON,T.,TOVEY,D.& FOR THE PRISMA FOR ABSTRACTs GROUP (2O13).PRISMA for abstracts:reporting   
systematicreviews injournalandconferenceabstracts.PLoSMedicine10,e1001419.   
BERGER-TAL,O., GREGGOR,A.L., MACURA,B., ADAMS,C.A., BLUMENTHAL,A.,   
BOUSKILA,A.,CANDOLIN，U.,DORAN,C.,FERNANDEZ-JURICIC,E., GOTANDA,K.M.，PRICE,C.,PUTMAN,B.J. SEGOLI，M., SNIJDERS,L., WoNG,B.B.M.,etal.(2019).Systematic reviews and mapsas tools forapplying behavioral ecology to management and policy.Behavioral Ecology 30,1-8.   
BORRIES,C., SANDEL,A.A.,KOENIG,A.,FERNANDEZ-DUQUE,E.,KAMILAR,J.M., AMOROSO,C.R.，BARTON,R.A.,BRAY,J.，DI FIORE,A.,GILBY,I.C., GORDON,A.D.,MUNDRY,R.,PORT,M.,POWELL,L.E.,PUSEY,A.E.,et al. (2016)．Transparency，usability,and reproducibility:guiding principles for   
improvingcomparativedatabasesusingprimatesasexamples.Eoutionary   
Anthropology:sde   
\*BOURDEAU,P.E.，BUTLIN，R.K.，BRONMARK,C.，EDGELL，T.C., HoVERMAN,J.T.& HoLLANDER,J.(2O15).What can aquatic gastropods tell us   
about phenotypic plasticity?A review and meta-analysis.Heredity 115,312-321.   
BRAMER, W.M.,DEJONGE,G.B.,RETHLEFSEN,M.L.,MAST,F.&KLEIJNEN,J. (2018).A systematic approach to searching: an eficient and complete method to developliteraturesearches.JournaloftheMedicalLibraryAsociation1o6,531-41.   
\*BREED,M.F., OTTEWELL,K.M.,GARDNER,M.G.,MARKLUND,M.H.K., DORMONTr,E.E.& LowE,A.J. (2015). Mating paterns and pollnator mobility are critical traits in forest fragmentation genetics.Heredity 115,lO8-114.   
BUTTNER,F.,WINTERS,M.,ELAHUNT,E.,EBER,R.,LURA,C.B.,KHAN,K.., WEIR,A.&ARDERN,C.L. (202O).Identifying the incredible'!Part 1:assesing the risk of bias in outcomes included in systematic reviews.British Joumal of Sports Medicine 54,798-800.   
\*CAPEK,P., MANZONI, S., KASTOVSKA,E., WILD, B., DIAKOVA, K,BA,J, SCHNECKER，J.，BIASI，C.,MARTIKAINEN，P.J.，ALVES，R.J.E., GUGGENBERGER,G.,GENTSCH,N.,HUGELIUS,G.,PALMTAG,J.,MIKUTTA,R., et al. (2O18).A plant-microbe interaction framework explaining nutrient effects on   
primary production.Nature EcologyEolution 2,1588-1596.   
\*CARUSO, C.M., EISEN,K.E., MARTIN,R.A.& SLETVOLD,N.(2O18).A metaanalysis of the agents of selection on floral traits.Evolution 73,4-14.   
\*CARUSO，C.M.，MARTIN，R.A.， SLETVOLD，N.，MORRISSEY，M.B., WADE,M.J.,AUGUSTINE,K.E., CARLSON,S. M.,MACCOLL,A.D.C.,   
SIEPIELSKI,A.M.& KINGSOLVER,J.G.(2017).Whatarethe environmental determinants of phenotypic selection?_A meta-analysis of   
experimental studies. The American Naturalist 190,363-376.   
CHAMBERLAIN,S.A.,HOVICK,S.M.,DIBBLE,C.J.,RASMUSSEN,N.L.,VAN ALLEN,B.G.，MAITNER,B.S.，AHERN,J.R.，BELL-DERESKE,L.P.,   
ROY,C.L.,MEZA-LOPEZ,M.,CARRILLO,J.，,SIEMANN,E., LAJEUNESSE,M.J.& WHITNEY,K.D. (2012).Does phylogeny matter? Assessing the impact of phylogenetic information in ecological meta-analysis.   
Ecology Letters15,627-636.   
\*CHAPLIN-KRAMER,R.,O'ROURKE,M.E., BLITZER,E.J.& KREMEN,C.(2011).A   
meta-analysis of crop pest and natural enemy response to landscape complexity. Ecology Letters14,922932.   
\*CONORD, C., GUREVITCH,J. &FADY,B.(2O12).Large-scale longitudinal gradients of genetic diversity:a meta-analysis across six phyla in the Mediterranean basin. EcologyandEolution2,6614   
COOKE,S.J., BIRNIE-GAUVIN,K,LENNOX,R.J.,TAYLOR,J.J.,RYTWINSKI,T., RUMMER,J.L.,FRANKLIN, C.E., BENNETT,J.R.& HADDAWAY, N.R.(2017).   
How experimental biology and ecology can support evidence-based decisionmaking in conservation:avoiding pitfalls and enabling application. Conservation Physiology 5,623.   
CoOPER,H.(2O).InHypothesesandProblemsinResearchSynthesis (ed.H.C),   
pp.19-35.Russell Sage Foundation,New York.   
tCoPAs,J.B.&L1,H.G.(1997).Inference for non-random samples.Journal ofthe Royal Statistical Society SeriesB-Methodological59,55-95.   
COTE,I.M.& JENNIONs,M.(2O13). The procedure of meta-analysis in a nutshell. In Handbook ofMeta-Analysis in Ecology and Evolution (edsJ.KoRICHEVA,J.GUREVITCHand   
K.MENGERsEN),pp.14-24.PrincetonUniversityPressPrinceton   
$^ *$ CRANE,A.L.& FERRARI, M. C.O. (2017). Pattrns ofpredator neophobia: a meta  
analyticreview.roceedingsoftheRoyalSocietyB:Biologicalciences28,2058.   
CURTIS，P.S.,MENGERSEN,K，LAJEUNESSE,M.J.，ROTHSTEIN,H.R. STEWART,G.B.(2O13).Extraction and critical appraisal of data.In Handbook of Meta-Analysis in Ecology and Euolution (edsJ.KoRICHEVA,J.GUREVITCH and K. MENGERSEN),pp.52-60.Princeton UniversityPress,Princeton.   
\*DAVIDSON,K.E.,FOWLER,M.S.,SKOV,M.W.,DOERR,S.H., BEAUMONT,N.& GRIFFIN,J. N. (20l7). Livestock grazing alters multiple ecosystem properties and services insaltmarshes:ameta-analysis.JoumalofAppliedEcology54,395-1405.   
\*DE BOECK,H.J.,BLOOR,J.M.G.,KREYLING,J.,RANSIJN,J.C.G.,NIJs,I, JENTSCH,A.& ZEITER,M. (2O18).Patterns and drivers of biodiversity-stability relationships under climate extremes.Journal of Ecology 106,890-902.   
\*DE KORT,H.,VANDEPITTE,K.&HONNAY,O. (2O12).A meta-analysis of theffects of plant traits and geographical scale on the magnitude of adaptive differentiation as measured by the difference between QSTand FST.Eoolutionary Ecology 27,1O8l-1097.   
DENNIS,B.,PONCIANO,J.M.,TAPER,M.L.&LELE, S.R.(2O19).ErrOrs in statistical inference under model misspecification: evidence, hypothesis testing，and AIC. Frontiers inEcologyandEuolution7,631.   
$^ *$ DESROCHES,S.,PO,D.,URLEY,N.E.,BLY,J.K,,A. KINNISON, M.T.,SCHWEITZER,J.A.& PALKOVACs,E.P. (2O18).The ecological importance of intraspecific variation.NatureEcologyEvolution2,57-64.   
\*DOBLER,R.,RoGELL,B., BUDAR,F.& DoWLING,D.K.(2O14). A meta-analysis of thestrengthand natureofcytoplasmic geneticeffcts.JourmalofEvolutionary Biology 27, 2021-2034.   
DoUGHERTY,L.R.& SHUKER,D.M.(2O15).The effect of experimental design on the measurement of matechoice: a meta-analysis.Behavioral Ecology 26,311-319.   
\*DUNN,R.E)ee metabolic rates.Biology Leters 14,20180190.   
\*DURRANT,H.M.S.,BURRIDGE,C.P.，KELAHER,B.P.， BARRETT,N.S., EDGAR,G.J. &CoLEMAN,M.A. 2013).Implicationsof macroalgalisolatioby distance for networks of marine protected areas.Conseruation Biology 28,438-445.   
↑DUVAL,S.& TwEEDIE,R.(200Oa).A nonparametric ‘trim and fil' method of accountingforpublication bias inmeta-analysis.Joumal of theAmerican Statistical Association 95,89-98.   
DUVAL,S.& TwEEDIE,R. (2Ooob).Trim and fil: a simple funnel-plot-based method of testing and adjusting for publicationbias in meta-analysis.Biometrics 56,455-463.   
\*EDGE,C.B.HOULAHAN,J.E,JACKSON,D.A.&FORTIN,-J.(2016) response of amphibian larvae to environmental change is both consistent and variable. Oikos 125,1700-1711.   
\*EDWARDS,KF.,AQUILINO,K.M.,BEST,R.J.， SELLHEIM,K.L.& STACHOwICz,J. J. (20l0).Prey diversity isasociated with weaker consumer effects ina meta-analysisofbenthic marine experiments.Ecology Leters13,194-201.   
EGGER,M.,DAVEY SMITH,G., SCHNEIDER,M.&MINDER,C.(1997).Bias in metaanalysis detectedbyasimple,graphical test.British Medical Joual 3i5,629-634.   
ELLINGTON,E.H.，BASTILLE-ROUSSEAU,G.,AUSTIN,C.,LANDOLT，K.N., POND,B.A.,REEs,E.E.,RoBAR, N.& MURRAY,D.L. (2O15). Using multiple imputation toestimatemissing datainmeta-regression.MethodsinEcologyand Evolution 6,153-163.   
\*ENGLISH,S.&UER,T.(2016).Doesearly-lifeietaffectlongevity?Ameta-aaysis across experimental studies.Biology Lettrs12,20160291.   
EvERs,J.L.H. (2O17).The Texas sharpshooter fallacy.Human Reproduction 32,1363- 1363.   
EWERS,R.M.，BARLOW,J.,BANKS-LEITE,C.& RAHBEK,C.(2O19).Separate authorship_categories to recognize data collectors and code developers. Nature EcologyEoolution3,1610-1610.   
\*EZIZ,A.,YAN,Z.,TIAN,D.,HAN,W.,TANG,Z.&FANG,J. (2O17).Droughtefect onplant biomassallcation:a meta-analysis.EcologyandEvolution7100 11010.   
$^ *$ FELKER-QUIN,EHWER,J..LY,J.K(3).eta-aalyi evolution ininvasiveplantspeciesbut litlesupportforevolutionof increased competitive ability (EICA).Ecology and Evolution 3,739-751.   
FORERO,D.A.,LOPEZ-LEON,S., GONZALEZ-GIRALDO,Y.& BAGOS,P.G. (2019). Tensimplerulesforcarryingout and writing meta-analyses.PLoSComputational Biology 15,e1006922-7.   
FORSTMEIER,W.& ScHELZETH,H.(2O11).Cryptic multiple hypotheses testing in linearodelsoerestatedsizesdthiersurseeloy and Sociobiology 65,47-55.   
FORSTMEIER,WWAGEAKs,E-J.&RKR,T.H017).Detctigandn likelyfalse-positivefings-racticalgie.ologicalReies9299.   
\*FRASER,D.J.,WEIR,L.K,RNATCHEZ,L.,HASEN,..&OR,E.B. (2011).Extent and scale of local adaptation in salmonid fishes: review and metaanalysis. Heredity 106,404-420.   
FRASER,H.,PARKER,T.,NAKAGAWA,S.,BARNETT,A.& FIDLER,F.(2018). Questionable research practices in ecology and evolution. PLoS One 13,e0200303.   
\*FUZESSY,L.F.,,.GJAC.A,F.A.O.(6). do primates afect seed germination? A meta-analysis of gut passage effects on neotropical plants.Oikos 125,1069-1080.   
$^ *$ GARAMSZEGI,L. Z., MARKó,G.& HERCZEG,G.(2O12).A meta-analysisof correlated behaviours with implications for behavioural syndromes: mean effect size,publication biasphylogeneticeffectsand theroleof mediator variables. Futinam Frnlm 26 11_1925 LLRJ' BEYENE，J.,CHANG,S.，CHURCHILL,R.，DEARNESS，K，GUYATT,G., LEFEBVRE,C.,LILES,B.,MARSHALL,R., GARCIA,L.M., MAVERGAMES,C., et al. (016).When and how to update systematic reviews: consensus and checklist. BritishMedicaloumal354,50.   
GATEs,S. (2Oo2). Review of methodology of quantitative reviews using meta-analysis in ecology.JourmalofAnimalEcology71,547-557.   
GELMAN,A. (20l8).Ethicsin statistical practiceand communication:five recommendations. Significance15,40-43.   
GELMAN,A. &CAIN,J. (2014).Beyond powercalculations:asessng tyeS(sign) and typeM(magnitude)errors.PerspectivesonPsychological Science9,641-651.   
GERSTNER，K，MORENO-MATEOS，D.，GUREVITCH，J.,BECKMANN,M., KAMBACH,S.,JONEs,H.P.&SEPPELT,R.(2017).Wilyour paperbe used ina meta-analysis?Makethereachofyourresearchbroaderandlongerlasting. MethodsinEcologyandEoolution8,777-784.   
GLESER,L.J.&OLI,I.(2OO9).Stochasticalldependent effect sizes.In TheHanbook ofResearch Synthesis_and Meta-Analysis (eds H.CoOPER,L.V.HEDGEsand J.C.   
GOLDACRE,B.(2O13).Bad Pharma:How Medicine Is Broken,and How We Can Fix It. VAENNE)u HarperCollnsPublishers,London   
GOLDACRE,B., MoRTON,C.E.&DEVITo,N.J. (2O19).Why researchers should share theiranalytic code.BritishMedical Journal 367,l6365.   
\*GORNE,L.D.&DiAz,S.(2017).Anovel meta-analyticalapproachto improve systematic reviewofratesndpattrnsofmcroevolution.EcologyandEolution7,58282.   
\*GREEN,D.M. (2oi9).Rarityof size-aortativemating inanimals:assessing the evidence withanuranamphibians.TheAmerican Naturalist193,279-295.   
\*GREENFIELD,M.D.,ALEM,S.,LIMOUSIN,D.&BAILEY,N.W.(2014).Thedilemma ofFisherian sexual selection: mate choice for indirectbenefits despite rarity and overall weakness oftrait-preferencegeneticorrelation.Eolution68,3524536.   
\*GREENWOOD，S.,RUIZ-BENITO，P.，MARTINEZ-VILALTA，J.,LLORET,F., KITZBERGER,T.,ALLEN,C.D.,FENSHAM,R., LAUGHLIN,D.C.,KATTGE,J., BONISCH, G.,KRAFT,N.J.B.&JUMP,A.S.(2O17).Tree mortality across biomes is promoted by drought intensity,lower wood density and higher specific leaf area. EcologyLetters,.   
GREGGOR,A.L.,PRICE,C.J.& SHIER,D.M.(2O19).Examining the efficacy of antipredator training for increasing survival inconservation translocations: asystematic review protocol.Environmental Evidence8,1-9.   
GUREVITcH,J. &HEDGEs,L.V. (1999).Statistical issues inecological meta-analyses. Ecology 80,1142-1149.   
GUREVITCH,J.,KORICHEVA,J.,NAKAGAWA,S.& STEWART,G. (2O18).Metaanalysis and the science of research synthesis.Nature 555,175-182.   
GUYATT,G.H.,OXMAN,A.D.,VIST,G.E.,KUNZ,R.,FALCK-YTTER,Y.,ALONSOCOELLO,P.& ScHUNEMANN,H. J. (2OO8). GRADE: an emerging consensus on rating quality of evidence and strength of recommendations.British Medical Joumal 336,924-926.   
HADDAWAY,N.R.,FEIERMAN,A., GRAINGER,M.J.,GRAY,C.T., TANRIVERAYDER,E.,DHAUBANJAR,S.& WESTGATE,M.J.(2O19).EviAtlas: a tool for visualising evidencesynthesis databases.Environmental Evidence8,58-210.   
HADDAWAY,N.R.& MACURA,B. (2018).The role of reporting standards in producing robust literature reviews.Nature Climate Change 8,444-447.   
HADDAWAY,N.R., MACURA,B.,WHALEY,P.& PULLIN,A.S.(2O18).ROSES RepOrting standards for systematic evidence syntheses: pro forma,flow-diagram and descriptive summary of the plan and conduct of environmental systematic reviewsand systematic maps.Environmental Evidence7,7.https://doi.org/10.1186/ s13750-018-0121-7.   
HADDAWAY,N.R.& VERHOEVEN,J.T.A. (2O15).Poor methodological detail precludes experimental repeatability and hampers synthesis in ecology. Ecology and Eolution 5,4451-4454.   
HADFIELD,J. D.& NAKAGAwA,S. (2Ol0). General quantitative genetic methods forcomparative biology:phylogenies,taxonomies and multi-trait models for continuous and categorical characters.Journal of Euolutionary Biology 23,494-508.   
\*HALUPKA,L.&A,K(7).eftatehgeheaof avianbreeding seasons:a meta-analysis.Proceedings of theRoyal SocietyB:Biological Sciences 284,20171710.   
HARON,es Independent Publishing Platform,Scots Valley.   
HARRIsON,F.(2O10).Geting started with meta-analysis.Methods inEcology and Euolution 2,1-10.   
HARRISON,X.A.,DONALDSON,L.,CORREA-CANO,M.E.,EVANS,J.,FISHER,D.N., GOODWIN,C.E.D.,ROBINSON,B.S.,HODGSON,D.J.&INGER,R.(2O18).Abrief introduction to mixed effects modelling and multi-model inference in ecology.Peer 6,e4794.   
\*HARVEY,B.P.,GwYNN-JONEs,D.& MOOE,P.J. (2013).Meta-analsisveals complex marine biological responses to the interactive efects of ocean acidification and warming Fmlm md Fnlutim 3 1016_1030   
HEAD,M.L.,HOLMAN,L.,LANFEAR,R., KAHN,A. T.& JENNIONS,M.D. (2015). The extent and consequences of P-hacking in science.PLoS Biology13,e1002106.   
HEARD，S.B.(2016).The Scientist’s GuidetoWriting.PrincetonUniversityPres, Princeton.   
\*HECTOR, K.L.,LAGIsz,M.& NAKAGAWA,S. (2012). The effect of resveratrolon longevityacrosspecies:ameta-analysis.iologyLeters8,790793.   
HEDGEs,L.V.(1984).Estimation of effect size under nonrandom sampling: the effectsof censoring studiesyielding statistically insignificant mean diferences. JourmalofEducationalStatistics9,61-85.   
HEDGEs,L.V.&PIGOTT,T.D.(2OO4).The power of statistical tests for moderators in meta-analysis.PsychologicalMethods9,426-445.   
HEDGEs,L.V.,TIPTON,E.& JOHNsON,M.C.(2O1O).Robust variance estimation in meta-regression with dependent effect size estimates.Research Synthesis Methods1, 39-65.   
HENMI, M.& CoPAs,J. B.(2OlO). Confidence intervals for random effects metaanalysis and robustness to publication bias.Statistics in Medicine 29,2969-2983.   
HERBISON,P.,HAY-SMITH,J.& GILLESPIE,W.J. (2OO6).Adjustment of metaanalyses on the basis of quality scores should be abandoned.Journal of Clinical Epidemiology 59,1249.e1-1249.e11.   
HIGGINS,J.P.T.,THOMAS,J.,CHANDLER,J.,CUMPSTON,M.,LI,T.,PAGE,M.J. & WELCH,V.A.(2O19).CochraneHandbook forSystematicReviewsofInterventions,2nd Edition.John Wiley & Sons, Chichester.   
HILLEBRAND,H.& GUREVITCH,J. (2O13).Reporting standards in experimental studies.Ecology Lettrs16,1419-1420.   
HoLCOMBE,A. O.(2Ol9).Contributorship,not authorship:use CRediT to indicate who did what.Publications 7(3),48.   
HOLMAN,L.,HEAD,M.L.,LANFEAR,R.& JENNIONS,M.D. (2O15). Evidence of experimental bias in the life sciences: why we need blind data recording. PLoS Biology 13,e1002190.   
HUTTON,B., SALANTI,G., CALDWELL,D. M., CHAIMANI,A., SCHMID,C.H, CAMERON,C., IOANNIDIS,J.P.A., STRAUS,S., THORLUND,K.,JANSEN,J.P., MULROW,C.，CATALA-LOPEZ，F.，GOTZSCHE，P.C.，DICKERSIN，K., BoUTRON,I.,et al. (2O15). The PRISMA extension statement for reporting of systematicreviewsincorporatingnetworkmeta-analysesofhealthcare interventions: checklist and explanations.Annals of Intermal Medicine 162,777-772.   
INTHOUT,J.,IOANNIDIS,J.P.A.,ROVERS,M.M.& GOEMAN,J.J. (2016).Plea for routinely presenting prediction intervals in meta-analysis.BMf Open 6,e010247.   
IOANNIDIs,J.P.A. (2O05).Why most published research findings are false.PLoS Medicine 2, e124.   
IOANNIDIs,J.P.A. (2O16).The mass production of redundant, misleading,and conflicted systematic reviews and meta-analyses.The Milbank Quarterly 94,485-514.   
IYENGAR,S.& GREENHOUsE,J.B.(1988). Selection models and the file drawer problem. Statistical Science 3,109-117.   
\*JACTEL,H.,GRITTI,E.S.,DROSSLER,L.,FORRESTER,D.I.,MASON,W.L., MORIN,X.,PRETZSCH,H.& CASTAGNEYROL,B. (2018).Positive biodiversity productivity relationships in forests: climate matters.Biology Letters 14,20170747. https://doi.org/10.1098/rsbl.2017.0747.   
JAMES,K.L.,RANDALL,N.P.& HADDAWAY,N.R. (2O16).A methodology for systematic mapping in environmental sciences.Enoironmental Evidence l-13.   
JARVINEN,A. (1991). A meta-analytic studyof the effctsoffemale age on laying-date and clutch-size in the greattitParus majorand the pied flycatcher Ficedula hypoleuca.Ibis 133,62-67.   
JENNIONS,M.D.,LORTIE,C.J.,ROSENBERG,M.S.& ROTHSTEIN,H.R.(2013). Publicationandrelatedbiases.InHandbookofMeta-AnalysisinEcologyandEvoution (eds J. KORICHEVA,J. GUREVITCH and K. MENGERSEN),Pp.207-236.Princeton University Press,Princeton.   
JENNIONs,M. D.& MoLLER,A.P.(20O2).Relationships fade with time: a metaanalysis of temporal trends in publication inecologyand evolution.Procedings of the Royal Society B:Biological Sciences 269,43-48.   
\*JESSOP,T.S.,LANE,M.L., TEASDALE,L., STUART-FOX,D.,WILSON,R. S., CAREAU,V.& MooRE,I. T. (2O16). Multiscale evaluation of thermal dependence in theglucocorticoid responseofvertebrates.The American Naturalist188,342-356.   
\*JIANG,Y.,BoLNICK,D.I.&KIRKPATRICK,M. (2O13).Asortative mating inanimals. The American Naturalist 181,El25-E138.   
\*KAMIYA,T.,O'DWYER,K.,WESTERDAHL,H.,SENIOR,A.&NAKAGAWA,S.(2014). A quantitativereviewofMHC-basedmating preference:theroleofdiversityand dissimilarity.Molecular Ecology 23,5151-5163.   
\*KARBAN,R., YANG,L.H.& EDWARDs,K.F. (2O13).Volatile communication between plants that affects herbivory:a meta-analysis.Ecology Letters17,44-52.   
KERR,N.L.(1998).HARKing: hypothesizing after the resultsare known.Personality and SocialPsychology Review 2,196-217.   
KETTENRING,K.M.& ADAMs,C.R. (2O11).Lessons learned from invasive plant control experiments: a systematic review and meta-analysis: invasive plant control experiments.Journalof Applied Ecology48,970-979.   
\*KINLOCK,N.L.,PROWANT,L,HERSTOFF,E.M.,FOLEY,C.M.,AKIN-FAJIYE,M., BENDER,N.,UMARANI,M.,RYU,H.Y., SEN,B.& GUREVITCH,J.(2018).   
Explainingglobalvariationinthelatitudinaldiversitygradient:met-analysis   
Confirms known paternsanduncovers newones.Global Ecology and Biogeography27, 125-141.   
+KORICHEVA,J.,GUREVITCH,J.&MENGERSEN,K. (2O13).Handbok of Meta-Analysis inEcology and Evolution.Princeton University Press,Princeton.   
KORICHEVA,J.& GUREVITcH,J. (2O14). Uses and misuses of meta-analysis in plant   
ecology.Journal ofEcology102,828-844.   
KORICHEVA,J.& KULINsKAYA,E. (2O19). Temporal instability of evidence base: a   
threat to policy making?Trends inEcology $\ddot { \odot }$ Evolution 34,895-902.   
\*KORICHEVA,J. &RoMERo, G.Q.(2012).You getwhat you payfor: reward-specific trade-offs among direct and ant-mediated defences in plants.Biology Leters 8, 628-630.   
\*KORNDER,N.A.,RIEGL,B.M.&FGUEREDO,J.(2018).Thresholdsanddives   
ofcoralcalcificationresponses toclimatechange.Global Change Biology24,5084 5095.   
KUEFFER,C.,NIINEMETS,U.,DRENOVSKY,R.E., KATTGE,J.,MILBERG,P.,   
POORTER,H.,REICH, P.B.,WERNER,C.,WESTOBY,M.&WRIGH,IJ. (2011).Fame,glory and neglect in meta-analyses.Trends in Ecology Euolution 26,493-494.   
LAGISZ,M., ZIDAR,J., NAKAGAWA, S., NEVILLE,V., SORATO,E.,PAUL, E. S., BATESON,M.，MENDL,M.& LovLIE,H.(202O).Optimism,pessmism and   
judgement bias in animals: a systematic reviewand meta-analysis.Neuroscience BiobehavioralRevies8,-17.   
LAJEUNEssE,M.J. (2Oo9). Meta-analysis and the comparative phylogenetic method. The American Naturalist174,369-381.   
LAJEUNEssE,M.J. (2O13). Recovering missing or partial data from studies: a survey of   
conversiosdimputatsfetaaalsis.IdbofetAalsy and Euolution (eds J. KORICHEVA,J. GUREVITCH and K.MENGERSEN),pp.195-206. Princeton University Press,Princeton   
LAJEUNEssE,M. J. (2016).Facilitating systematic reviews, data extraction and meta-analysis with the metagearpackage for R.Methods in Ecology and Evolution 7, 323-330.   
LANE,P.W., ANZURES-CABRERA,J.,LEWIS,S.& TOMLINSON,J. (2O12). Graphics formeta-analysis.InAPictureIsWorth a Thousand Tables (edsA.KRAUSE and M.   
OCoNNELL),908SpringerUto   
\*LEHMANN,A.,ZHENG,W.& RILLIG,M.C.(2O17).Soil biota contributions to soil   
aggregation.Nature Ecology Evolution1,1828-1835.   
LEIMU,R.& KoRICHEVA,J.(2004). Cumulative meta-analysis: a new tool for detectionof temporal trendsand publication bias inecology.Proceeings of the Royal   
Society ofLondon.SeriesB:Biological Sciences 271,1961-1966.   
\*LI,F.-R.,PENG,S.-L., CHEN,B.-M.& HoU,Y.-P. (201O).A meta-analysisof the responses of woody and herbaceous plants to elevated ultraviolet-B radiation.Acta Oecologica 36,1-9.   
LIBERATI,A.,ALTMAN,D.G.,TETZLAFF,J.,MULROW,C.,GOTZSCHE,P.C., IOANNIDIS,J.P.A., CLARKE,M.,DEVEREAUX,P.J., KLEIJNEN,J.& MOHER,D.   
(2009).ThePRISMAstatement forreporting_systematicreviewsandmetaanalysesof studies that evaluate healthcare interventions:explanation and   
elaboration.British Medical Joumal 339,b2700.   
LITTELL,J.A.,CoRCORAN,J.&PILLAI,V.(2OO8).SystematicReviews andMeta-Analysis. Oxford University Press,New York.   
LITTLE,R.J.A.&RuB,D.B.(2O2).StatisticalAnalysiswithMissngData3rddtio   
Wiley,Hoboken.   
LOPEZ-LOPEZ,J. A.,PAGE,M.J.,LIPSEY,M.W.&HIGGINs,J.P.T. (2O18).Dealing with effect size multiplicity in systematic reviews and meta-analyses.Research Synthesis Methods 68,1282.   
\*LOYDI,A.,ECKSTEIN,R.L.,OTTE,A.&DONATH,T.W.(2O12).Efects of litron seedling establishment in natural and semi-natural grassands: a meta-analysis.   
Jourmal of Ecology 101,454-464.   
\*MA,C.,LI,S.,PU,Z,TAN,J.,IU,.,ZHOU,J.,L,H.&JANG,L.(6) Different efects of invader-native phylogenetic relatedness on invasion success and impact:a meta-analysisof Darwin's naturalization hypothesis.Procedings of the Royal Society B:Biological Sciences 283,2O160663.   
\*MA,Z.&C,H.YH.(16).Efectsofspciesdiversityoferootproductiity indiverseecosystems:aglobal meta-analysis.Global EcologyandBiogeography 25,387- 1396.   
MANN,T.(2015).TheOxfordGudetoLibraryResearch4thEdition.OxfordUniversity Press, Oxford.   
\*MASSAD,T.J.(213).Ontogeneticdiferenesofherivoyonwodyndbo plants: a meta-analysis demonstrating unique efects of herbivory on the young and the old,the slow and the fast. Oecologia 172,1-10.   
\*MAZIA,N.，MOYANO,J.,，PEREZ,L.，AGUIAR，S.，GARIBALDI，L．A.& SCHLICHTER,T. (2O16).The sign and magnitude of tree-grass interaction along a global environmental gradient.GlobalEcologyandBiogeography25,15101519.   
MCGOWAN,J., SAMPSON,M.,SALZWEDEL,D.M.,COGO,E.,FOERSTER,V.&   
LEFEBRC.6o   
$^ *$ MCLEAN,M.J.,BIsHOP,P.J.& NAKAGAWA,S.(2012).Male quality，signal reliability and female choice: asssing the expectations of inter-sexual selection. Jourmal ofEoolutionaryBiology 25,1513-1520.   
↑McSHANE,B.B.，BOCKENHOLT,U.& HANSEN,K. T.(2016).Adjusting for publication bias in meta-analysis: an evaluation of selection methods and some cautionary notes.Perspectives onPsychological Science11,730-749.   
MENGERSEN,K.& GUREVITCH,J. (2O13).Using other metrics of effect size in meta-analysis.In Handbook ofMeta-AnalysisinEcology_and Euolution (edsJ. KORICHEVA,J. GUREVITCH and K.MENGERSEN), pp.72-85.Princeton University Press, Princeton.   
$^ *$ MERKLING,T., NAKAGAWA,S.,LAGISZ,M.& SCHWANZ,L.E.(2O18). Maternal testosterone_and offspring sex-ratio in birdsand mammals:a meta-analysis. Evolutionary Biology45,96-104.   
METEYARD,L.& DAvIEs,R.A.I. (2O2O).Best practice guidance for linear mixedeffectsmodels inpsychologicalscience.JoumalofMemoryandLanguage112,04092.   
\*MILLER,S.E.,RUE,M.&SHUTR,D.(2017).Aomparativeanalisof experimental selection on the stickleback pelvis.Journal of Euoutionary Biology 30, 1165-1176.   
$^ *$ MOATT,J.P.,NAKAGAWA,S.,LAGIZ,M.& WALLING,C.A. (2O16).efect dietaryrestrictiononreproduction:ameta-aalyticperspective.BMEoluoy Biology 16,401.   
MOHER,D.,BOUTER,L.,KLEINERT,S.,GLASZIOU,P.,SHAM,M.H.,BARBOUR,V., CORIAT,A.-M.,FoEGER,N.& DIRNAGL,U.(2O2O).The Hong Kong principles for assessing researchers: fostering research integrity.PLoS Biology 18,e3000737.   
MOHER,D.,COOK,D.J.,EATWOOD,S.,OLKIN,I.,RENNIE,D.&STROUP,D.F. (1999). Improving the quality of reports of meta-analyses of randomised controlled trials: the QUOROM statement.The Lancet 354,1896-1900.   
MOHER,D., LIBERATI, A.,TETZLAFF,J.,ALTMAN,D.G.& THE PRISMA GROUP (2009).Preferred reporting items for systematic reviews and meta-analyses: the PRISMAstatement.PLoSedicine6,e000097.   
MOHER,D.,NAUDET,F.,CRISTEA,I.A.,MIEDEMA,F.,IOANNIDIS,J.P.A.& GOODMAN,S.N. (2018).Assessing scientists for hiring,promotion,and tenure. PLoS Biology 16,e2004089.   
MOHER，D.，SHAMSEER,L.，CLARKE,M.，GHERSI，D.，LIBERATI，A., PETTICREW,M.,SHEKELLE,P., STEWART,L.A.,ALTMAN,D.G., BOOTH,A., CHAN,A.W.,CHANG,S.,CLIFFORD,T.,DICKERSIN,K.,EGGER,M.,et al. (2015).Preferred reporting items for systematic review and meta-analysis protocols (PRISMA-P) 2015 statement. Systematic Reviews 4,el000326.   
M0LLER,A.P.&JENNIONs,M. D.(2OO1). Testing and adjusting for publication bias. Trends in EcologyEvolution16,580-586.   
$^ *$ MOORE,M.P.,RIESCH,R.& MARTIN,R.A. (2016).The predictability and magnitudeof life-history divergence to ecological agentsof selection:a metaanalysis in livebearing fishes.Ecology Letters19,435-442.   
MORENO,S. G., SUTTON,A. J., ADES,A.， STANLEY, T. D., ABRAMS,K.R., PETERs,J. L.& CooPER,N.J. (20O9). Assessment of regression-based methods to adjust for publication bias through a comprehensive simulation study. BMC Medical Research Methodology 9,2.   
MORRIssEY,M.B. (2016).Meta-analysis of magnitudes,diferences and variation in evolutionary parameters.Journal of Eoolutionary Biology 29,1882-1904.   
MUKA,T.,GLISIC,M.，MILIC,J.，VERHOOG,S.，BOHLIUS,J.，BRAMER,W., CHOWDHURY, R.& FRANCO,O.H. (2020).A 24-step guide on how to design, conduct,and successfully publish a systematic review and meta-analysis in medical research.European Journal ofEpidemiology 35,49-60.   
MUNAFO，M.R.，CHAMBERS,C.D.，COLLINS，A.M.，FORTUNATO,L.& MACLEOD,M.R. (2O2O).Research culture and reproducibility.Trends in Cognitive Sciences 24,91-93.   
$^ *$ MUNDIM,F.M.& BRUNA,E.M.(2016).Is therea temperate bias inour understanding of how climate changewill alter plant-herbivore interactions? A meta-analysis of experimental studies.The American Naturalist188,S74-S89.   
$^ *$ MURPHY,G.E.P.& RoMANUK,T.N.(2012).A meta-analysis of community response predictability to anthropogenic disturbances. The American Naturalist 180, 316-327.   
$^ *$ MURPHY,G.E.P.& RoMANUk,T.N. (2013).A meta-analysis of declines in local species richness from human disturbances.Ecology and Evolution 4, 91-103.   
$^ *$ MURREN,C.J.,MACLEAN,H.J.,DIAMOND,S.E.,STEINER,U.K.,HESKEL,.A., HANDELSMAN,C.A.,GHALAMBOR,C.K,AULD,J.R., CALLAHAN,H.S., PFENNIG,D.W.,RELYEA,R.A., SCHLICHTING,C.D.& KINGSOLVER,J. (2014). Evolutionary change in continuous reaction norms.The American Naturalist 183, 453-467.   
MURTAUGH,P.A. (2O02).Journal quality,effect size,and publication bias in metaanalysis.Ecology 83,1162-1166.   
NAKAGAWA, S.& DE VILLEMEREUIL,P.(2O19).A general method for simultaneously accounting for phylogenetic and species sampling uncertainty via Rubin's rules in comparative analysis.Systematic Biology 68,632-641.   
NAKAGAWA,S.&,R.P.8).iiactiothgen missing data.Trends inEcologyEolution23,592-596.   
NAKAGAWA, S.& LAGIsZ,M. (ZUio). VIsuaIIzing unDIasea ana DIasea unweigntea meta-analyses.Journal ofEvolutionary Biology 29,1914-1916.   
NAKAGAWA,S.&LAGISz,M. (2019). How good does our map of knowledge have to be?:a commenton Berger-Tal etal.Behavioral Ecology 30,13-14.   
NAKAGAWA,S.，LAGISZ,M.，O'DEA，R.E.，RUTKOWSKA,J., YANG,Y., NOBLE,D.W.A.& SENIOR,A.M. (2O2O). The orchard plot: cultivating a forest plot for use in ecology,evolution,and beyond.Research Synthesis Methods 12, 4-12.   
NAKAGAWA,S.,NOBLE,D.W.A., SENIOR,A. M.& LAGISZ,M. (2O17). Metaevaluation of meta-analysis: ten appraisal questions for biologists.BMC Biology 15,3.   
NAKAGAWA，S.， SAMARASINGHE, G.，HADDAWAY，N.R.，WESTGATE,M.J., O'DEA,R.E.,NoBLE,D.W.A.& LAGISZ,M. (2019).Research weaving: visualizing the futureofresearchsynthesis.Trends inEcologyEoolution 34,224-38.   
NAKAGAwA,S.& SANTos,E.S.A. (20l2). Methodological issues and advances in biological meta-analysis.Evolutionary Ecology 26,1253-1274.   
NELSON,L.D., SIMMONs,J.& SIMONSOHN,U. (2O18).Psychology's renaissnce. Annual Review ofPsychology 69,511-534.   
\*NIEMELA,P.T.& DINGEMANSE，N.J. (2O18).Meta-analysis revealsweak associationsbetween intrinsic stateand personality.Procedings of the Royal Society B: Biological Sciences 285,20172823.   
NOBLE，D.W.A.,LAGISZ,M.,O'DEA，R.E.& NAKAGAWA，S.(2017). Nonindependence and sensitivity analyses in ecological and evolutionary metaanalyses.MolecularEcology 26,2410-2425.   
NOSEK,B.A.，ALTER,G.，BANKS，G.C.，BORSBOOM,D.， BOWMAN，S.D., BRECKLER,S.J.,BUCK,S.,CHAMBERS,C.D.,CHIN,G.,CHRISTENSEN,G., CONTESTABILE,M.,DAFOE,A.,EICH,E., FREESE,J.,GLENNERSTER,R.,et al. (2015).Promotinganoenresearchcuture.Sience 348,1422-1425.   
NOSEK,B.A.,BECK,E.D.,CAMPBELL,L,FAKE,J.K,HARDWICKE,.E, MELLOR,D.T., VAN T VEER& VAZIRE, S.(2O19).Preregistration is hard,and worthwhile.Trends in Cognitive Sciences 23,815-818.   
NOSEK,B.A., EBERSOLE,C.R.,DEHAVEN,A.C.& MELLOR,D.T.(2018). The preregistrationrevolution.Procedingsof theNationalAcademyof Sciencesof the United States ofAmerica 15,2600-2606.   
O'BOYLE,E.H. JR.,BANKs,G.C.& GONZALEZ-MULE,E.(2O17).The Chrysalis effect.JoumalofManagement43,376-99.   
\*O'BRIEN,J. M.& ScHEIBLING,R.E.(2O18).Turf wars: competition between foundation and turf-forming species on temperate and tropical reefs and its role in regimeshifts.arinecologyrogresseries597.   
†O'DEA,R.E.,LAGISZ,M.,HENDRY,A.P.& NAKAGAWA,S. (2O19). Developmental temperature affects phenotypic means and variability: a meta-analysis of fish data. Fish and Fisheries 12,523-518.   
\*ORD,T.J.,K,L.&Yo,A.R.01).Contrastingtheory withtheeal data of species recognition.Evolution 65,2572-2591.   
tORWIN,R.G.(1983).Afail-safeNfor efect size in meta-analysis.JoumalofEducational Statistics 8,157.   
OUZZANI,M.,HAMMADY,H.,FEDOROWICZ, Z.& ELMAGARMID,A. (2016). Rayan-awebandmobileapforsystematicreviews.Sstematic Reies5,1.   
PAGE,M.J.,MOHER,D., BOSSUYT,P.M.,BOUTRON,L,HOFFMANN,T.C., MULROW,C.D., SHAMSEER,L., TETZLAFF,J.M.,AKL,E.A.,BRENNAN,S.E., CHOU,R., GLANVILLE,J.,GRIMSHAW,J. M.,HROBJARTSSON,A.,LALU,M. M., et al. (202la). PRISMA 2020 explanation and elaboration: updated guidance and exemplars forreporting systematicreviews.British MedicalJoumal 372,n160.   
PAGE,M.J.,CKEIE,J.E.,OU,P.,OUON,I.,.C MULROW,C.D., SHAMSEER,L., TETZLAFF,J. M.,AKL, E.A.,BRENNAN,S.E., CHOU,R.,GLANVILLE,J.,GRIMSHAW,J. M.,HROBJARTSSON,A.,LALU,M. M., et al. (2021b).The PRISMA 2020 statement:anupdated guidelineforreporting systematic reviews.British Medical Joumal 372,n71.   
PAGE,M.J.& MoHER,D.(2Ol7).Evaluations of the uptake and impact of the preferredreporting items for systematicreviewsand meta-analyses (Prisma). Statementand extensions: ascoping review.Systematic Revieus 6,263.   
PALPACUER, C.,HAMMAS, K, DUPREZ,R,LAVIOLLE,B.,IOANNIDIS,J. P.A.& NAUDET,F.(2O19).Vibration of effects from diverse inclusion/exclusion criteria and analytical choices: 9216 different ways to perform an indirect comparison meta-analysis.BMC Medicine17,1-13.   
PAREKH-BHURKE,S., KWOK,C.S.，PANG,C.，HOOPER,L., LOKE,Y.K., RYDER,J.J.,SUTTON,A.J.,HING,C.B., HARVEY,I.& SONG,F.(2011). Uptake of methods to deal with publication bias in systematic reviews has increased over time,but there is still much scope for improvement.Journal of Clinical Epdemiology64,49-57.   
PARKER,T.,FRASER,H.& NAKAGAWA, S.(2O19).Making conservation science more reliable with preregistrationand registered reports.Conseruation Biology 33,747-750.   
PARKER,T.H.,FORSTMEIER, W., KORICHEVA,J.,FIDLER,F.,HADFIELD,J.D, CHEE,Y.E.,K,C.D.&NAGAA,S.(216a).ransparencyinolog and evolution: real problems,real solutions.Trends in Ecology Euolution 31, 711_710   
[AKKER, 1. I., GKEIG, L. ., NAKAGAWA,S., rARKA, M. Q DALISIU,A. U. (ZU1Od). Subspecies status and methods explainstrength of response to local versus foreign song by oscine birds in meta-analysis.Animal Behaviour 142,1-17.   
PARKER,T.H.,GRIFFITH, S.C.,BRONSTEIN,J.L.,FIDLER,F., FOSTER,S., FRASER,H.,FORSTMEIER,W., GUREVITCH,J.,KORICHEVA,J, SEPPELT,R., TINGLEY,M.W.&NKAGAwA,S.(2018b).Empoweringpeerreviewers witha checklist to improve transparency.Nature Ecology $\ddot { \odot }$ Evolution 2,929–935.   
PARKER,T.H.,NAKAGAWA,S., GUREVITCH,J.& IIEE (IMPROVING INFERENCE IN EVOLUTIONARY BIOLOGY AND ECOLOGY）WORKSHOP PARTICIPANTS (2016b). Promoting transparencyinevolutionarybiologyand ecology.Ecology Leters19(7),726-728.   
\*PEARSON,D.E.,ORTEGA,Y.K,RUNYON,J.B.&BUTLER,J.L.(2O16).Secondary invasion: the bane of weed management. Biological Conseruation197,8-17.   
\*PERE,C.,JACTEL,H.& KENIs,M. (20l3).Response of insect parasitism to elevation depends onhostand parasitoid life-hstorystrategies.BiologyLeters 9,20130028.   
PICCOLO,S.R.& FRAMPTON,M.B. (2016). Tools and techniques for computational   
reproducibility. GigaScience 5,1226.   
PICK,J. L.,NAKAGAWA,S.& NoBLE,D.W.A. (2O19).Reproducible,fexible and high-throughput data extraction from primary literature: the metaDigitise R package.MethodsinEcologyandEolution10,26-.   
\*PIETSCH,K.A.，OGLE,K.，CORNELISSEN, J.H.C.，CORNWELL,W.K, BONISCH,G., CRAINE,J. M., JACKSON,B.G.,KATTGE,J.,PELTZER,D.A., PENUELAS,J.,REICH,P.B.,WARDLE,D.A.,WEEDON,J.T.,WIGHJ, ZANNE，A.E.,et al.(2O14).Global relationship of wood and leaf liter decomposability:the role of functional traits within and across plant organs.Global Ecology and Biogeography 23,1046-1057.   
\*POMBI，M.，KENGNE,P.，GIMONNEAU,G.，TENE-FOSSOG，B.，AYALA，D., KAMDEM，C.，SANTOLAMAZZA，F.,GUELBEOGO，W.M.，SAGNON，N., PETRARCA,V., FONTENILLE,D., BESANSKY,N.J.,ANTONIO-NKONDJIO,C., DABIRE,R.K.,DELLA ToRRE,A.,et al. (2O17).Dissecting functional components of reproductive isolation among closely related sympatric species of the Anopheles   
gambiaecomplex.Evoutionary Applications10,1102-1120.   
\*PROKOP,Z.M.,MICHALCZYK,L.,DROBNIAK,S.M.,HERDEGEN,M.&RADWAN,J. (2012).Meta-analysis suggests choosy females get sexy sons more than “good genes". Evolution 66,2665-2673.   
\*PRZESLAWsKI,R., BYRNE, M.& MELLIN, C. (2O15).A review and meta-analysis of theeffects of multipleabiotic stressors onmarineembryosand larvae.Global Change Biology 21,2122-2140.   
PULLIN,A.S.& STEWART,G.B.(2OO6).Guidelines for systematic review in conservation and environmental management. Conseruation Biology 20,1647-1656.   
PUSSEGODA,K.，TURNER，L.，GARRITTY，C.，MAYHEW，A.，SKIDMORE,B., STEVENS,A.,BOUTRON,I,SARKIS-ONOFRE,R.,BJERRE,L.M., HRóBJARTsSON,A.,ALTMAN,D.G.& MOHER,D. (2O17).Systematic review adherence to methodological or reporting quality. Systematic Reviews 6,131.   
PYSEK,P.,RICHARDSON,D.M.,PERGL,J.,JAROSIK,V.,SIXTOVA,Z.& WEBER,E. (2008).Geographical and taxonomic biases in invasion ecology.Trends in Ecology Eolution 23,237-244.   
RATHBONE,J.,CARTER,M.,HOFFMANN,T.& GLASZIOU,P.(2O15a).Better duplicate detection for systematic reviewers:evaluation of systematic review assistant-Deduplication module.Systematic Reviews 4,1-6.   
RATHBONE,J.,HOFFMANN,T.& GLASZIOU,P.(2O15b).Faster title and abstract screening?EvaluatingAbstrackr,asem-automatedonlinescreening progamfor systematic reviewers.Systematic Reviews 4,1.   
RCoRETA.(O18)R:ALggendEoentforStatiscalCoVie Austria: R Foundation for Statistical Computing,   
RETHLEFSEN,M.L.,KIRTLEY,S.,WAFFENSCHMIDT,S.,AYALA,A.P.,OHR,D, PAGE,M.J.,KOFFEL,J. B.&PRISMA-S GROUP (2O21).PRISMA-S: an extension to the PRISMA statement for reporting literature searches in systematic reviews. Systematic Reviews 10,39.   
RICE,D.B.& MoHER,D.(2O19).Curtailing the use ofpreregistration: a misused term. Perspectives onPsychological Science 14,1105-1108.   
\*RIFKIN,J.L,NUNN,C.L.& GARAMSZEGI,L.Z.(2O12).Do animals iving in larger groups experience greater parasitism?A meta-analysis.The American Naturalist 180, 70-82.   
ROCHE,D.G., KRUUK,L.E.B.,LANFEAR,R.& BINNING,S.A.(2O15).Public data archiving in ecology and evolution: how wellare we doing?PLoS Biology 13, e1002295.   
\*ROFF,D.A.& FAIRBAIRN,D.J.(2Ol2).A test of the hypothesis that correlational   
selection generatesgeneticcorrelations.Eolution66,2953-2960.   
\*ROSA,R.,RUMMER,J.L.& MUNDAY,P.L.(2Ol7).Biological responses of sharks to ocean acidification.Biology Letters13,20160796.   
+RosENBERG,M.S. (2Oo5).The file-drawer problem revisited: a general weighted method for calculating fail-safe numbers in meta-analysis.Evolution 59,464-468.   
RoSENBERG, M.S. (2013).Moment and least-squares based approachestometaanalyticinference.InHandbookofMeta-AnalysisinEcologyandEvolution (edsJ. KORICHEVA,J.GUREvHndK.ENGERE),.108124.PricetonUit Press, Princeton.   
ROSENBERG,M.S.，ROTHSTEIN,H.R.& GUREVITCH,J.(2O13).Effect sizes: conventional choicesand calculations.In Handbook of Meta-Analysis in Ecology and Evolution (eds J.KORICHEVA,J.GUREVITCH and K.MENGERSEN)，Pp.61-71. Princeton University Press,Princeton.   
RoSENTHAL,R.(1979).The file drawer problem and tolerance for null results. Psychological Bulleti 86,38-641.   
ROSENTHAL，M.F.，GERTLER，M.，HAMILTON，A.D.，PRASAD，S．& ANDRADE,M. C.B.(2Ol7).Taxonomic bias in animal behaviour publications. Animal Behaviour 127,83-89.   
ROTHSTEIN,H.R.,SUTTON,A.J.&BORENSTEIN,M.(2OO5).Publication Bias in MetaAnalysis.JohnWiley&ons,Ltd,Chicht   
\*RowINsKI,P.K.&RoGELL,B.(2O17). Environmental stress correlates with inreases inboth genetic and residual variances: a meta-analysis of animal studies.Evolution 71, 1339-1351.   
RUTKOWSKA,J.,DUBIEC,A. & NAKAGAWA,S.(2O13). All eggs are made equal: metaanalysisof eggsexualsizedimorphisminbirds.foualofElutionaryBiology27, 153-160．   
\*SAMIA,D.S.M.,NoMURA,F.& BLUMSTEIN,D.T. (2O13).Do animals generaly flush early and avoid the rush?A meta-analysis.Biology Leters 9,2O130016.   
\*SANCHEZ,C.A.,BECKER,D.J.,TTELBAUM,C.S.,BRRIGA,P.,BROWN,L.M MAJEWSKA,A.A.,HALL,R.J. & ALTIZER,S.(2O18).On the relationship between bodyconditionand parasite infection in wildlife:areviewand meta-analysis.Ecology Letters 21,1869-1884.   
SANCHEZ-TOJAR,A.，NAKAGAWA,S.,SANCHEZ-FORTUN,M.，MARTIN,D.A., RAMANI，S.，GIRNDT，A.,BOKONY，V.，KEMPENAERS，B.，LIKER,A., WESTNEAT,D.F.,BURKE,T.& ScHROEDER,J. (2O18).Meta-analysis challenges a textbook example of status signalling and demonstrates publication bias.eLife 7, aac4716.   
SANDVE,G.K.,NEKRUTENKO,A.,TAYLOR,J.&HOVIG,E. (2O13).Ten simple rules for reproduciblecomputational research.PLoS Computational Biology 9,el003285.   
\*SEIBOLD,S.，BASSLER，C.，BRANDL，R.，GOSSNER,M.M.，THORN,S., ULYSHEN,M.D.& MULLER,J. (2015).Experimental studies of dead-wood biodiversity—areviewidentifying global gaps in knowledge.Biological Conservation 191,139-149.   
SENIOR，A.M.，GRUEBER,C.E.，KAMIYA，T.，LAGISZ，M.，O'DWYER，K., SANTOS,E.S.A.& NAKAGAWA,S.(2016).Heterogeneity in ecological and evolutionary meta-analyses:itsmagnitudeand implications.Ecology97,3293- 3299.   
↑SHAMSEER，L.，MOHER,D.，CLARKE，M.，GHERSI，D.，LIBERATI，A, PETTICREW,M.,SHEKELLE,P.,STEWART,L.A.& THE PRISMA-P GROUP (2015).Preferred reporting items for systematic reviewand meta-analysis protocols (PRISMA-P) 2015:elaboration and explanation.Brtish Medical Journal 349, g7647.   
\*SHANTZ,A.A.,LEMINE,N.P.&BURKEPILE,D.E. (2O15).Nutrientloading alters the performance of key nutrient exchange mutualisms.Ecology Leters 19,20-28.   
SHOLLER,D.,RAM,K,BOETTIGER, C.& KATz,D.S.(2O19). Enforcing public data archiving policies in academic publishing:a study of ecology journals.Big Data $\ddot { \odot }$ Society 6,205395171983625.   
SIDDAWAY,A.P., WoOD,A. M.& HEDGEs,L.V.(2019).How to do a systematic review: a best practice guide for conducting and reporting narrative reviews, metaanalyses,and meta-sytheses.AnmualReviewofPsychology70,747-770.   
SIMMON,J.P.U(1.ssie undiscosedfebiltatacoloaaasllospreseig significant.Psychological Sience22,359-166.   
\*SINGH,A.& PuNzALAN,D. (2O18).The strength of sex-specific selection in the wild. Eoolution 72,2818-2824.   
\*SLATYER,R.A.,HIRST,M.& SEXTON,J.P. (2013).Niche breadth predicts geographical range size: a general ecological pattern.Ecology Lettrs 16,11041114.   
\*SLOT,M.&KITAJIMA,K. (2O14). General patterns of acclimation of leaf respiration to elevated temperaturesacrossbiomesand planttypes.Oecologia778900.   
SMALDINO,P.E.& McELREATH,R.(2O16).The natural selection ofbad science.Royal Society Open Science3,60384.   
\*SMITH,R.K.,PULLIN,A.S.,STEWART,G.B.& SUTHERLAND,W.J. (2010). Effectiveness of predator removal for enhancing bird populations.Conservation Biology 24,820-829.   
\*SMITH,R.K.,PULLIN,A.S.,STEWART,G.B.& SUTHERLAND,W.J. (2O11).Is nest predator exclusion an effective strategy for enhancing bird populations? Biological Conseruation144,1-10.   
\*SORENSON,G.H,Dy,C.J.,IGER,C.L.VE,O.P.(216).Ecs ofbaseliecorticosteroneasamonitoring toolforfiess ameta-analysis insairds. Oecologia 183,353-365.   
STEWART,G.(2OlO).Meta-analysis inapplied ecology.Biology Leters6,78-81.   
STEWART,G.B.,CoTE,I. M.,RoTHSTEIN,H.R.&CURTIs,P.S.(2013).Firsttein beginningameta-analysis.InHandbookofMeta-Analysis inEcologyandEoolution (edsJ. KORICHEVA,J.GUREViTCH andK.MENGERSEN)，pp.27-36.Princeton University Press Prinretnn   
STEWART,L.A.,CLARKE,M.，ROVERS，M.，RILEY，R.D.，SIMMONDS，M., STEWART,G.& TIERNEY,J.F.(2O15).Preferred reporting items for a systematic reviewand meta-analysis of individual participant data.Journal of the American Medical Association 313,1657-1659.   
STODDEN,V., SEILER,J.& MA,Z. (2O18).An empirical analysis of journal policy effectivenessforcomputationalreproducibility.ProcedingsoftheNatonalAcademyof SciencesoftheUnitedStatesofAmerica115,2584-2589.   
SZOLLOSI,A.,KELLEN,D.,NAVARRO,D.J., SHIFFRIN,R.,VAN ROOIJ,I,VAN ZANDT,T.& DoNKIN,C.(2O2O).Is preregistration worthwhile? Trends in Cognitive Sciences 24,94-95.   
\*TEMME,A.A.，CORNWELL, W. K,CORNELIEN,J. H. C. &AERTS,R. (2013). Meta-analysis reveals profound responses of plant traits to glacial CO2 levels. Ecology and Euolution 3,4525-4535.   
TERRIN,N.,SHMD,C.H.,LAU,J. &OLKIN,I. (2OO3).Adjustingforpublicatioias in the presence of heterogeneity.Statistics in Medicine 22,2113-2126.   
\*THOMSEN,M.S.,ALTIERI,A. H.,ANGELINI, C.,BISHOP,M.J.,GRIBBEN,P.E., LEAR,G.，HE,Q，SCHIEL，D.R.，SILLIMAN，B.R.,SOUTH,P.M, WATSON,D.M.,WERNBERG,T.& ZoTZ,G.(2Ol8). Secondary foundation species enhance biodiversity.Nature Ecology Euolution 2,634-639.   
\*THURMAN,T.J.& BARRETT,R.D.H.(2O16).The genetic consequences of selection in natural populations.Molecular Ecology 25,1429-1448.   
TIPTON,E.,PUsTEJOVsKY,J.E.& AHMADI,H.(2O19).A history of meta-regression: technical,conceptual,and practical developments between 1974 and 2018.Research SynthesisMethods10,161-179.   
\*ULLER,T.,NAKAGAWA,S.& ENGLIsH,S. (2013).Weak evidence for anticipatory parental effects inplantsandanimals.JournalofEvolutionaryBiology 26,2161-2170.   
VALENTINE,J.C.,PIGOTT,T.D.&RoTHSTEIN,H.R.(2O1O).HOW many studies do you need?:a primer on statistical power for meta-analysis.Joumal of Educational and Behavioral Statistics 35,215-247.   
tVAN AERT,R.C.M.,WICHERTS,J.M.& VAN ASSEN,M.A.L.M.(2016). Conducting meta-analyses based on p values: reservations and recommendations forapplying p-uniformand p-curve.Perspectives on Psychological Science11,713-729.   
\*VAN KATWIJK,M.M.,THORHAUG,A.,MARBA,N., ORTH,R.J.,DUARTE, C.M., KENDRICK,G.A,ALTHUIZEN,I.H.J.，BALESTRI,E.,BERNARD,G., CAMBRIDGE,M.L.,CUNHA,A.，DURANCE,C.，GIESEN,W.，HAN,Q, HosOKAwA，S.，et al.(2Ol5).Global analysis of seagrass restoration: the importance of large-scale planting.Joumal ofApplied Ecology 53,567-578.   
VAN WILGENBURG,E.& ELGAR,M.A. (2O13).Confirmation bias in studies of nestmate recognition: a cautionary note for research into the behaviour of animals. PLoS One 8,e53548.   
\*VERESOGLou, S.D.& RILLIG,M.C.(2O12). Suppression of fungal and nematode plant pathogens through arbuscular mycorrhizal fungi. Biology Letters 8,214-217.   
VETTER,D.,RUcKER,G.& STORCH,I. (2O13).Meta-analysis: a need for well-defined usage in ecologyand conservation biology.Ecosphere4,1-24.   
VEVEA,J.L.,CoBURN,K.&SuTTON,A. (2019).Publicationbias.InTheHandbook of Research Synthesis and Meta-Analysis (eds H. CoOPER,L.V.HEDGEsand J.C. VALENTINE),pp.383-430.Rusell SageFoundation,NewYork.   
\*VOGWILL,T.& MAcLEAN,R.C.(2014).The genetic basis of the fitnessCostsof antimicrobialrsisance:ametaanalysispproachEolutioaryApplications8,8495.   
\*VoJE,K.L. (2016).Scalingof morphological charactersacrosstrait type,sexnd environment: a meta-analysis of static allometries.The American Naturalist187,89-98.   
\*VRANCKX, G.,JACQUEMYN,H., MUYs,B.& HONNAY,O. (2011). Meta-analysis of susceptibility of woody plants toloss ofgenetic diversitythrough habitat fragmentation. Conseruation Biology 26,228-237.   
\*WAN,J. S.H.,PANG, C.K.& BoNSER, S.P.(2O17).Does the cost of adaptation to extremely stressful environments diminish over time?A literature synthesis on how plants adapt to heavy metals and pesticides. Eoolutionary Biology 44,411-426.   
tWANG,M. C.& BusHMAN,B.J. (1998). Using the normal quantile plot to explore meta-analytic data sets.Psychological Methods 3,46-54.   
\*WEHI,P.M.,NAKAGAWA,S.,TREWICK,S.A.& MORGAN-RICHARDS,M. (2011). Does predation result in adult sex ratio skew in a sexually dimorphic insect genus? Jourmal ofEvolutionary Biology 24,2321-2328.   
†WELCH,V.,PETTICREW,M.,PETKOVIC,J.,MOHER,D.,WATERS,E.,WHITE,H., TUGWELL，P.，ATUN，R.，AWASTHI，S.，BARBOUR，V.，BHUTTA，Z.A., CUERVO,L.G.,GROVES,T., KOEHLMOOS-PEREZ,T.,KRISTJANSSON,E., et al. (2016).Extending the PRISMA statement to equity-focused systematic reviews (PRISMA-E 2Ol2): explanation and elaboration.Joumal of Clinical Epidemiology 70, 68-89.   
WESTGATE,M.J. (2Ol9).Revtools:an R package to support article screening for evidence synthesis.Research Synthesis Methods10,606-614.   
WHITTAKER,R.J. (2OlO).Meta-analyses and mega-mistakes: calling time on metaanalysis of the species richness-productivity relationship.Ecology 91,2522-2533.   
WILKINSON,M.D.，DUMONTIER,M.，AALBERSBERG,I. J.,APPLETON，G., AXTON,M.,BAAK,A.,BLOMBERG,N.,BOITEN,J.-W.,DA SILVA SANTOS,L.B., BOURNE,P.E.,BOUWMAN,J.，BROOKES,A.J.,CLARK,T.,CROSAS,M, DILLO,I.，et al. (2O16).The FAIR guiding principles forscientific data management and stewardship.Scientific Data 3,160018.   
WILLIs,B.H.& RILEY,R.D. (2O17).Measuring the statistical validity of summary meta-analysis and meta-regresson results for use in clinical practice.Statistics in Medicine 36,3283-3301.   
\*WOOD,J.L.A.,YATEs,M.C.&FRASER,D.J. (2016).Are heritabilityandselection related to population size in nature?Meta-analysis and conservation implications. Evolutionary Applications 9,640-657.   
\*X1,N., ZHANG,C.& BooR,J. M.G.(2O17).Species richnessalters spatial nutrient heterogeneity effects on above-ground plant biomass.Biology Letters 13,20170510.   
\*YATEs,M.C.& FRAsER,D.J.(2014).Does source population size affect performance in new environments? Eoolutionary Applications7,871-882.   
\*ZHANG,L.& Lu,X. (20l2).Amphibians live longer at higher altitudes but not at higherlatitudes.BiologicalJoumal oftheLinneanSociety1o6,623-632.   
↑ZORZELA,L.,LOKE,Y.K,IOANNIDIS,J.P.,GOLDER,S.，SANTAGUIDA,P., ALTMAN,D.G.,MOHER,D.,VOHRA,S.& PRISMA HARMS GROUP (2016). PRISMA harms checklist: improving harms reporting in systematic reviews.British Medical Fournal 352,i157.   
\*ZVEREVA,E.L.& KozLov,M.V. (2Ol1).Sources of variation in plant responses to belowground insect herbivory:a meta-analysis.Oecologia 169,441-452.   
\*ZVEREVA,E.L.& KozLov,M.V. (2014).Effectsof herbivoryon leaflife span in woody plants: a meta-analysis.Joumal of Ecology 102,873-881.

# XVII. Supporting information

Additional supporting information may be found online in the Supporting Information section at the end of the article. Appendix S1. Supporting Information